// node_modules/@atlassian/aui/src/js/aui/label.js
(typeof window === 'undefined' ? global : window).__2b259c5aed9b54ccee8476578e5d68b9 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  
  var _skate = __ace7dcceb4a59d9f981848fc5f0a3bcf;
  
  var _skate2 = _interopRequireDefault(_skate);
  
  var _skatejsTemplateHtml = __acf1a8a2ea3648a5bc697a9962e4e302;
  
  var _skatejsTemplateHtml2 = _interopRequireDefault(_skatejsTemplateHtml);
  
  var _enforcer = __cc9ec5979cb746af454174edc175f18f;
  
  var _enforcer2 = _interopRequireDefault(_enforcer);
  
  var _constants = __d385943f48a2095a99d4854bbf9920fd;
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  function getLabel(element) {
      return element.querySelector('label');
  }
  
  function updateLabelFor(element, change) {
      if (element.hasAttribute('for')) {
          getLabel(element).setAttribute('for', '' + change.newValue + _constants.INPUT_SUFFIX);
      } else {
          getLabel(element).removeAttribute('for');
      }
  }
  
  function updateLabelForm(element, change) {
      if (element.hasAttribute('form')) {
          getLabel(element).setAttribute('form', change.newValue);
      } else {
          getLabel(element).removeAttribute('form');
      }
  }
  
  var Label = (0, _skate2.default)('aui-label', {
      template: (0, _skatejsTemplateHtml2.default)('<label><content></content></label>'),
      created: function created(element) {
          element._label = getLabel(element); // required for quick access from test
      },
      attached: function attached(element) {
          (0, _enforcer2.default)(element).attributeExists('for');
      },
      attributes: {
          'for': updateLabelFor,
          form: updateLabelForm
      },
      prototype: {
          get disabled() {
              return this.hasAttribute('disabled');
          },
          set disabled(value) {
              if (value) {
                  this.setAttribute('disabled', '');
              } else {
                  this.removeAttribute('disabled');
              }
          }
      },
      events: {
          click: function click(element, e) {
              if (element.disabled) {
                  e.preventDefault();
              }
          }
      }
  });
  
  exports.default = Label;
  module.exports = exports['default'];
  
  return module.exports;
}).call(this);