// node_modules/@atlassian/aui/src/js/aui/events.js
(typeof window === 'undefined' ? global : window).__bf4c32b87195c47ca7087f8c77ddee31 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  exports.triggerEvtForInst = exports.triggerEvt = exports.bindEvt = undefined;
  
  var _jquery = __205998b249afc65053be53fe079b2622;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _deprecation = __bec41a89fad5278f895ed424cdf50be7;
  
  var deprecate = _interopRequireWildcard(_deprecation);
  
  var _createElement = __9cafbf2ea7bd105c6c296b132f08cc0c;
  
  var _createElement2 = _interopRequireDefault(_createElement);
  
  var _globalize = __90e6b3a7b5f251fe6bee9d0accee9418;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  /**
   * Triggers a custom event on the AJS object
   *
   * @param {String} name - name of event
   * @param {Array} args - args for event handler
   */
  function triggerEvt(name, args) {
      (0, _jquery2.default)(_createElement2.default).trigger(name, args);
  }
  
  /**
   * Binds handler to the AJS object
   *
   * @param {String} name
   * @param {Function} func
   */
  function bindEvt(name, func) {
      (0, _jquery2.default)(_createElement2.default).bind(name, func);
  }
  
  /**
   * Some generic error handling that fires event in multiple contexts
   * - on AJS object
   * - on Instance
   * - on AJS object with prefixed id.
   *
   * @param evt
   * @param inst
   * @param args
   */
  function triggerEvtForInst(evt, inst, args) {
      (0, _jquery2.default)(inst).trigger(evt, args);
      triggerEvt(evt, args);
      if (inst.id) {
          triggerEvt(inst.id + '-' + evt, args);
      }
  }
  
  exports.bindEvt = bindEvt = deprecate.fn(bindEvt, 'bindEvt', {
      sinceVersion: '5.8.0'
  });
  
  exports.triggerEvt = triggerEvt = deprecate.fn(triggerEvt, 'triggerEvt', {
      sinceVersion: '5.8.0'
  });
  
  exports.triggerEvtForInst = triggerEvtForInst = deprecate.fn(triggerEvtForInst, 'triggerEvtForInst', {
      sinceVersion: '5.8.0'
  });
  
  (0, _globalize2.default)('bindEvt', bindEvt);
  (0, _globalize2.default)('triggerEvt', triggerEvt);
  (0, _globalize2.default)('triggerEvtForInst', triggerEvtForInst);
  
  exports.bindEvt = bindEvt;
  exports.triggerEvt = triggerEvt;
  exports.triggerEvtForInst = triggerEvtForInst;
  
  return module.exports;
}).call(this);