// node_modules/@atlassian/aui/src/js/aui/blanket.js
(typeof window === 'undefined' ? global : window).__a5891e87986f92a8e06507ac5b91df13 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  exports.undim = exports.dim = undefined;
  
  var _deprecation = __bec41a89fad5278f895ed424cdf50be7;
  
  var _animation = __2ed95b5559992bbb8aa930ba13cf5c0e;
  
  var _createElement = __9cafbf2ea7bd105c6c296b132f08cc0c;
  
  var _createElement2 = _interopRequireDefault(_createElement);
  
  var _globalize = __90e6b3a7b5f251fe6bee9d0accee9418;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  var overflowEl;
  var _hiddenByAui = [];
  
  /**
   * Dims the screen using a blanket div
   * @param useShim deprecated, it is calculated by dim() now
   */
  function dim(useShim, zIndex) {
  
      //if we're blanketing the page it means we want to hide the whatever is under the blanket from the screen readers as well
      function hasAriaHidden(element) {
          return element.getAttribute('aria-hidden') ? true : false;
      }
  
      function isAuiLayer(element) {
          return element.className.match(/\baui-layer\b/) ? true : false;
      }
  
      Array.prototype.forEach.call(document.body.children, function (element) {
          if (!hasAriaHidden(element) && !isAuiLayer(element)) {
              element.setAttribute('aria-hidden', 'true');
              _hiddenByAui.push(element);
          }
      });
  
      if (!overflowEl) {
          overflowEl = document.body;
      }
  
      if (useShim === true) {
          useShimDeprecationLogger();
      }
  
      var isBlanketShowing = !!dim.$dim && dim.$dim.attr('aria-hidden') === 'false';
  
      if (!!dim.$dim) {
          dim.$dim.remove();
          dim.$dim = null;
      }
  
      dim.$dim = (0, _createElement2.default)('div').addClass('aui-blanket');
      dim.$dim.attr('tabindex', '0'); //required, or the last element's focusout event will go to the browser
      dim.$dim.appendTo(document.body);
  
      if (!isBlanketShowing) {
          //recompute after insertion and before setting aria-hidden=false to ensure we calculate a difference in
          //computed styles
          (0, _animation.recomputeStyle)(dim.$dim);
  
          AJS.dim.cachedOverflow = {
              overflow: overflowEl.style.overflow,
              overflowX: overflowEl.style.overflowX,
              overflowY: overflowEl.style.overflowY
          };
  
          overflowEl.style.overflowX = 'hidden';
          overflowEl.style.overflowY = 'hidden';
          overflowEl.style.overflow = 'hidden';
      }
  
      dim.$dim.attr('aria-hidden', 'false');
  
      if (zIndex) {
          dim.$dim.css({ zIndex: zIndex });
      }
  
      return dim.$dim;
  }
  
  /**
   * Removes semitransparent DIV
   * @see dim
   */
  function undim() {
      _hiddenByAui.forEach(function (element) {
          element.removeAttribute('aria-hidden');
      });
  
      _hiddenByAui = [];
  
      if (dim.$dim) {
          dim.$dim.attr('aria-hidden', 'true');
  
          if (overflowEl) {
              overflowEl.style.overflow = AJS.dim.cachedOverflow.overflow;
              overflowEl.style.overflowX = AJS.dim.cachedOverflow.overflowX;
              overflowEl.style.overflowY = AJS.dim.cachedOverflow.overflowY;
          }
      }
  }
  
  var useShimDeprecationLogger = (0, _deprecation.getMessageLogger)('useShim', {
      extraInfo: 'useShim has no alternative as it is now calculated by dim().'
  });
  
  (0, _globalize2.default)('dim', dim);
  (0, _globalize2.default)('undim', undim);
  
  exports.dim = dim;
  exports.undim = undim;
  
  return module.exports;
}).call(this);