/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.MatcherUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class RegularExpressionMatcher
implements Predicate<URI> {
    private final Pattern pattern;

    public RegularExpressionMatcher(String expression) {
        this.pattern = Pattern.compile((String)Preconditions.checkNotNull((Object)expression, (Object)"expression"));
    }

    public boolean apply(URI uri) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return this.pattern.matcher(normalizedUri.toString()).matches();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

