/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.MatcherUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.net.URISyntaxException;

public class ExactUrlMatcher
implements Predicate<URI> {
    private final URI expression;

    public ExactUrlMatcher(String expression) {
        this.expression = MatcherUtils.normalizeUriUnchecked(URI.create((String)Preconditions.checkNotNull((Object)expression, (Object)"expression")));
    }

    public boolean apply(URI uri) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return this.expression.equals(normalizedUri);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

