/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.core.WhitelistRulePredicates;
import com.atlassian.plugins.whitelist.core.applinks.ApplicationLinkWhitelistRule;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ApplicationLinkChangeListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLinkChangeListener.class);
    private final EventPublisher eventPublisher;
    private final WhitelistManager whitelistManager;
    private final TransactionTemplate transactionTemplate;
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private boolean started;

    public ApplicationLinkChangeListener(EventPublisher eventPublisher, WhitelistManager whitelistManager, TransactionTemplate transactionTemplate, ReadOnlyApplicationLinkService applicationLinkService) {
        this.eventPublisher = eventPublisher;
        this.whitelistManager = whitelistManager;
        this.transactionTemplate = transactionTemplate;
        this.applicationLinkService = applicationLinkService;
    }

    @EventListener
    public void onApplicationLinkAdded(ApplicationLinkAddedEvent event) {
        if (this.started) {
            this.add((ReadOnlyApplicationLink)event.getApplicationLink());
        }
    }

    @EventListener
    public void onApplicationLinkIdChanged(ApplicationLinksIDChangedEvent event) {
        if (this.started) {
            this.update(event.getOldApplicationId(), (ReadOnlyApplicationLink)event.getApplicationLink());
        }
    }

    @EventListener
    public void onApplicationLinkDeleted(ApplicationLinkDeletedEvent event) {
        if (this.started) {
            this.remove(event.getApplicationLink().getId());
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        final Collection whitelistedApplicationLinkIds = Collections2.transform((Collection)Collections2.filter((Collection)this.whitelistManager.getAll(), WhitelistRulePredicates.withType(WhitelistType.APPLICATION_LINK)), (Function)new Function<WhitelistRule, String>(){

            public String apply(WhitelistRule whitelistRule) {
                return whitelistRule.getExpression();
            }
        });
        Iterable nonWhitelistedApplicationLinks = Iterables.filter((Iterable)this.applicationLinkService.getApplicationLinks(), (Predicate)new Predicate<ReadOnlyApplicationLink>(){

            public boolean apply(ReadOnlyApplicationLink applicationLink) {
                return !whitelistedApplicationLinkIds.contains(applicationLink.getId().get());
            }
        });
        this.add(nonWhitelistedApplicationLinks);
        this.started = true;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private void add(final ReadOnlyApplicationLink applicationLink) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                Collection existingRules = ApplicationLinkChangeListener.this.findAllWhitelistedApplicationLinksWithId(applicationLink.getId());
                if (existingRules.isEmpty()) {
                    ApplicationLinkChangeListener.this.whitelistManager.add((WhitelistRule)new ApplicationLinkWhitelistRule(applicationLink));
                }
                return null;
            }
        });
    }

    private void add(final Iterable<ReadOnlyApplicationLink> applicationLinks) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                for (ReadOnlyApplicationLink applicationLink : applicationLinks) {
                    ApplicationLinkChangeListener.this.whitelistManager.add((WhitelistRule)new ApplicationLinkWhitelistRule(applicationLink));
                }
                return null;
            }
        });
    }

    private void update(final ApplicationId oldApplicationId, final ReadOnlyApplicationLink applicationLink) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                LinkedList applinksWithOldApplicationId = Lists.newLinkedList((Iterable)ApplicationLinkChangeListener.this.findAllWhitelistedApplicationLinksWithId(oldApplicationId));
                WhitelistRule first = (WhitelistRule)applinksWithOldApplicationId.pollFirst();
                if (first != null) {
                    ImmutableWhitelistRule expression = ImmutableWhitelistRule.builder().copyOf(first).expression(ApplicationLinkWhitelistRule.getExpressionFrom(applicationLink)).build();
                    ApplicationLinkChangeListener.this.whitelistManager.update((WhitelistRule)expression);
                }
                ApplicationLinkChangeListener.this.whitelistManager.removeAll((Iterable)applinksWithOldApplicationId);
                return null;
            }
        });
    }

    private void remove(final ApplicationId applicationId) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                Collection applinksWithId = ApplicationLinkChangeListener.this.findAllWhitelistedApplicationLinksWithId(applicationId);
                ApplicationLinkChangeListener.this.whitelistManager.removeAll((Iterable)applinksWithId);
                return null;
            }
        });
    }

    private Collection<WhitelistRule> findAllWhitelistedApplicationLinksWithId(ApplicationId applicationId) {
        String expression = ApplicationLinkWhitelistRule.getExpressionFrom(applicationId);
        WhitelistType type = WhitelistType.APPLICATION_LINK;
        Collection result = Collections2.filter((Collection)this.whitelistManager.getAll(), (Predicate)Predicates.and(WhitelistRulePredicates.withType(type), WhitelistRulePredicates.withExpression(expression)));
        if (result.size() > 1) {
            logger.warn("Found more than one whitelist entry for the application link with id '{}'.", (Object)applicationId);
        }
        return result;
    }
}

