/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRuleBuilder;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistOnOffSwitch;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.core.WhitelistRuleNotFoundException;
import com.atlassian.plugins.whitelist.core.WhitelistRulePredicates;
import com.atlassian.plugins.whitelist.core.permission.PermissionChecker;
import com.atlassian.plugins.whitelist.events.ClearWhitelistCacheEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleAddedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleChangedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleRemovedEvent;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WhitelistServiceImpl
implements WhitelistService,
InitializingBean,
DisposableBean {
    private final WhitelistOnOffSwitch whitelistOnOffSwitch;
    private final WhitelistManager whitelistManager;
    private final PermissionChecker permissionChecker;
    private final EventPublisher eventPublisher;
    private final CachedReference<Collection<WhitelistRule>> cache;

    public WhitelistServiceImpl(WhitelistOnOffSwitch whitelistOnOffSwitch, final WhitelistManager whitelistManager, PermissionChecker permissionChecker, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.whitelistOnOffSwitch = whitelistOnOffSwitch;
        this.whitelistManager = whitelistManager;
        this.permissionChecker = permissionChecker;
        this.eventPublisher = eventPublisher;
        this.cache = cacheManager.getCachedReference(WhitelistServiceImpl.class.getName() + ".cache", (Supplier)new Supplier<Collection<WhitelistRule>>(){

            public Collection<WhitelistRule> get() {
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)whitelistManager.getAll(), (Function)ImmutableWhitelistRuleBuilder.COPY));
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public boolean isWhitelistEnabled() {
        return this.whitelistOnOffSwitch.isEnabled();
    }

    public void enableWhitelist() {
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        this.whitelistOnOffSwitch.enable();
    }

    public void disableWhitelist() {
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        this.whitelistOnOffSwitch.disable();
    }

    public WhitelistRule add(WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        WhitelistServiceImpl.checkTypeNotApplicationLink(whitelistRule);
        return this.whitelistManager.add(whitelistRule);
    }

    public WhitelistRule update(WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        Integer whitelistRuleId = whitelistRule.getId();
        Preconditions.checkArgument((whitelistRuleId != null ? 1 : 0) != 0, (Object)("Cannot update whitelist rule, the given instance has no database id: " + whitelistRule));
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        this.enforceApplicationLinkUpdateRules(whitelistRule);
        return this.whitelistManager.update(whitelistRule);
    }

    public void remove(int id) {
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        WhitelistRule whitelistRule = this.get(id);
        if (whitelistRule != null) {
            WhitelistServiceImpl.checkTypeNotApplicationLink(whitelistRule);
            this.whitelistManager.remove(whitelistRule);
        }
    }

    public Collection<WhitelistRule> getAll() {
        return (Collection)this.cache.get();
    }

    @Nullable
    public WhitelistRule get(int id) {
        return (WhitelistRule)Iterables.find((Iterable)((Iterable)this.cache.get()), WhitelistRulePredicates.withId(id), null);
    }

    @EventListener
    public void onWhitelistRuleAddedEvent(WhitelistRuleAddedEvent event) {
        this.cache.reset();
    }

    @EventListener
    public void onWhitelistRuleChanged(WhitelistRuleChangedEvent event) {
        this.cache.reset();
    }

    @EventListener
    public void onWhitelistRuleRemoved(WhitelistRuleRemovedEvent event) {
        this.cache.reset();
    }

    @EventListener
    public void onClearWhitelistCacheEvent(ClearWhitelistCacheEvent event) {
        this.cache.reset();
    }

    private static void checkTypeNotApplicationLink(WhitelistRule whitelistRule) {
        if (whitelistRule.getType() == WhitelistType.APPLICATION_LINK) {
            throw new IllegalArgumentException("Adding new application link whitelist rules is not supported, they are managed internally.");
        }
    }

    private void enforceApplicationLinkUpdateRules(WhitelistRule whitelistRule) {
        Integer whitelistRuleId = whitelistRule.getId();
        Preconditions.checkNotNull((Object)whitelistRuleId, (Object)"whitelistRuleId");
        WhitelistRule existingWhitelistRule = this.get(whitelistRuleId);
        if (existingWhitelistRule == null) {
            throw new WhitelistRuleNotFoundException("Whitelist rule with id '" + whitelistRuleId + "' not found.");
        }
        if (existingWhitelistRule.getType() == WhitelistType.APPLICATION_LINK) {
            Preconditions.checkArgument((whitelistRule.getType() == WhitelistType.APPLICATION_LINK && whitelistRule.getExpression().equals(existingWhitelistRule.getExpression()) ? 1 : 0) != 0, (Object)"Cannot change the type or expression of this application link whitelist rule.");
        } else {
            Preconditions.checkArgument((whitelistRule.getType() != WhitelistType.APPLICATION_LINK ? 1 : 0) != 0, (Object)"Cannot change the type to application link.");
        }
    }
}

