/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public class WhitelistRulePredicates {
    public static Predicate<WhitelistRule> withId(final int id) {
        return new Predicate<WhitelistRule>(){

            public boolean apply(@Nullable WhitelistRule input) {
                Integer whitelistRuleId = input != null ? input.getId() : null;
                return whitelistRuleId != null && id == whitelistRuleId;
            }
        };
    }

    public static Predicate<WhitelistRule> withType(final WhitelistType type) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        return new Predicate<WhitelistRule>(){

            public boolean apply(@Nullable WhitelistRule input) {
                return input != null && type == input.getType();
            }
        };
    }

    public static Predicate<WhitelistRule> withExpression(final String expression) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression");
        return new Predicate<WhitelistRule>(){

            public boolean apply(@Nullable WhitelistRule input) {
                return input != null && expression.equals(input.getExpression());
            }
        };
    }
}

