/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.whitelist.WhitelistOnOffSwitch;
import com.atlassian.plugins.whitelist.events.ClearWhitelistCacheEvent;
import com.atlassian.plugins.whitelist.events.WhitelistDisabledEvent;
import com.atlassian.plugins.whitelist.events.WhitelistEnabledEvent;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WhitelistOnOffSwitchImpl
implements WhitelistOnOffSwitch,
InitializingBean,
DisposableBean {
    private static final String WHITELIST_ENABLED_KEY = "com.atlassian.plugins.atlassian-whitelist-api-plugin:whitelist.enabled";
    private static final boolean ENABLED_BY_DEFAULT = true;
    private static final Logger logger = LoggerFactory.getLogger(WhitelistOnOffSwitchImpl.class);
    private final CachedReference<Boolean> enabled;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final EventPublisher eventPublisher;

    public WhitelistOnOffSwitchImpl(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.eventPublisher = eventPublisher;
        this.enabled = cacheManager.getCachedReference(WhitelistOnOffSwitchImpl.class.getName() + ".enabled", (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return BooleanUtils.toBooleanDefaultIfNull((Boolean)WhitelistOnOffSwitchImpl.this.loadValue(), (boolean)true);
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void enable() {
        this.storeValue(true);
        this.enabled.reset();
        logger.debug("Whitelist has been enabled.");
        this.eventPublisher.publish((Object)WhitelistEnabledEvent.INSTANCE);
    }

    public void disable() {
        this.storeValue(false);
        this.enabled.reset();
        logger.debug("Whitelist has been disabled.");
        this.eventPublisher.publish((Object)WhitelistDisabledEvent.INSTANCE);
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    @EventListener
    public void onClearWhitelistCacheEvent(ClearWhitelistCacheEvent event) {
        this.enabled.reset();
    }

    @Nullable
    private Boolean loadValue() {
        Object o = this.settings().get(WHITELIST_ENABLED_KEY);
        return BooleanUtils.toBooleanObject((String)ObjectUtils.toString((Object)o, null));
    }

    private void storeValue(boolean enabled) {
        this.settings().put(WHITELIST_ENABLED_KEY, (Object)Boolean.toString(enabled));
    }

    private PluginSettings settings() {
        return this.pluginSettingsFactory.createGlobalSettings();
    }
}

