/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.core.ao.AoWhitelistRule;
import com.atlassian.plugins.whitelist.core.ao.AoWhitelistRuleDao;
import com.atlassian.plugins.whitelist.core.matcher.RegularExpressionMatcher;
import com.atlassian.plugins.whitelist.events.WhitelistRuleAddedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleChangedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleRemovedEvent;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;

class WhitelistManagerImpl
implements WhitelistManager {
    private final AoWhitelistRuleDao aoWhitelistRuleDao;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;

    public WhitelistManagerImpl(AoWhitelistRuleDao aoWhitelistRuleDao, TransactionTemplate transactionTemplate, EventPublisher eventPublisher) {
        this.aoWhitelistRuleDao = aoWhitelistRuleDao;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
    }

    public WhitelistRule add(WhitelistRule whitelistRule) {
        return (WhitelistRule)Iterables.getOnlyElement(this.addAll(Collections.singleton(whitelistRule)));
    }

    public Collection<WhitelistRule> addAll(final Iterable<WhitelistRule> whitelistRules) {
        Preconditions.checkNotNull(whitelistRules, (Object)"whitelistRules");
        Collection addedWhitelistRules = (Collection)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Collection<WhitelistRule>>(){

            public Collection<WhitelistRule> doInTransaction() {
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)whitelistRules, (Function)new Function<WhitelistRule, WhitelistRule>(){

                    public WhitelistRule apply(@Nullable WhitelistRule whitelistRule) {
                        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
                        WhitelistManagerImpl.validate(whitelistRule);
                        return WhitelistManagerImpl.this.aoWhitelistRuleDao.add(whitelistRule);
                    }
                }));
            }
        });
        for (WhitelistRule whitelistRule : addedWhitelistRules) {
            this.eventPublisher.publish((Object)new WhitelistRuleAddedEvent(whitelistRule));
        }
        return addedWhitelistRules;
    }

    public WhitelistRule update(final WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        final Integer whitelistRuleId = whitelistRule.getId();
        Preconditions.checkArgument((whitelistRuleId != null ? 1 : 0) != 0, (Object)("Cannot update whitelist rule, the given instance has no database id: " + whitelistRule));
        WhitelistRule updatedWhitelistRule = (WhitelistRule)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<WhitelistRule>(){

            public WhitelistRule doInTransaction() {
                AoWhitelistRule aoWhitelistRuleData = WhitelistManagerImpl.this.aoWhitelistRuleDao.get(whitelistRuleId);
                WhitelistManagerImpl.validate(whitelistRule);
                aoWhitelistRuleData.setExpression(whitelistRule.getExpression());
                aoWhitelistRuleData.setType(whitelistRule.getType());
                aoWhitelistRuleData.setAllowInbound(whitelistRule.isAllowInbound());
                aoWhitelistRuleData.save();
                return aoWhitelistRuleData;
            }
        });
        this.eventPublisher.publish((Object)new WhitelistRuleChangedEvent(updatedWhitelistRule));
        return updatedWhitelistRule;
    }

    public void remove(WhitelistRule whitelistRule) {
        this.removeAll(Collections.singleton(whitelistRule));
    }

    public void removeAll(final Iterable<WhitelistRule> whitelistRules) {
        Preconditions.checkNotNull(whitelistRules, (Object)"whitelistRules");
        Collection removedWhitelistRules = (Collection)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Collection<WhitelistRule>>(){

            public Collection<WhitelistRule> doInTransaction() {
                Iterable transform = Iterables.transform((Iterable)whitelistRules, (Function)new Function<WhitelistRule, WhitelistRule>(){

                    public WhitelistRule apply(WhitelistRule whitelistRule) {
                        Preconditions.checkNotNull((Object)whitelistRule);
                        Integer id = whitelistRule.getId();
                        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)("Cannot remove whitelist rule, the given instance has no database id: " + whitelistRule));
                        AoWhitelistRule aoWhitelistRuleData = WhitelistManagerImpl.this.aoWhitelistRuleDao.get(id);
                        if (aoWhitelistRuleData == null) {
                            return null;
                        }
                        WhitelistManagerImpl.this.aoWhitelistRuleDao.remove(id);
                        return aoWhitelistRuleData;
                    }
                });
                return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)transform, (Predicate)Predicates.notNull()));
            }
        });
        for (WhitelistRule removedWhitelistRule : removedWhitelistRules) {
            this.eventPublisher.publish((Object)new WhitelistRuleRemovedEvent(removedWhitelistRule));
        }
    }

    public Collection<WhitelistRule> getAll() {
        return (Collection)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Collection<WhitelistRule>>(){

            public Collection<WhitelistRule> doInTransaction() {
                return ImmutableList.copyOf(WhitelistManagerImpl.this.aoWhitelistRuleDao.getAll());
            }
        });
    }

    @Nullable
    public WhitelistRule get(final int id) {
        return (WhitelistRule)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<WhitelistRule>(){

            public WhitelistRule doInTransaction() {
                return WhitelistManagerImpl.this.aoWhitelistRuleDao.get(id);
            }
        });
    }

    private static void validate(WhitelistRule whitelistRule) {
        if (whitelistRule.getType() == WhitelistType.REGULAR_EXPRESSION) {
            new RegularExpressionMatcher(whitelistRule.getExpression());
        } else if (whitelistRule.getType() == WhitelistType.APPLICATION_LINK) {
            try {
                UUID.fromString(whitelistRule.getExpression());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Expected whitelist rule of type application link to have an expression of a valid UUID: " + whitelistRule);
            }
        }
    }
}

