/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.core.applinks.ApplicationLinkMatcher;
import com.atlassian.plugins.whitelist.core.matcher.DomainNameMatcher;
import com.atlassian.plugins.whitelist.core.matcher.ExactUrlMatcher;
import com.atlassian.plugins.whitelist.core.matcher.RegularExpressionMatcher;
import com.atlassian.plugins.whitelist.core.matcher.WildcardExpressionMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultWhitelistRuleMatcher
implements Predicate<URI> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWhitelistRuleMatcher.class);
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private final WhitelistRule whitelistRule;
    private final ImmutableMap<WhitelistType, Function<WhitelistRule, Predicate<URI>>> mappings = ImmutableMap.of((Object)WhitelistType.APPLICATION_LINK, this.createApplicationLinkRule(), (Object)WhitelistType.EXACT_URL, this.createExactUrlRule(), (Object)WhitelistType.WILDCARD_EXPRESSION, this.createWildcardExpressionRule(), (Object)WhitelistType.REGULAR_EXPRESSION, this.createRegularExpressionRule(), (Object)WhitelistType.DOMAIN_NAME, this.createDomainNameRule());

    public DefaultWhitelistRuleMatcher(ReadOnlyApplicationLinkService applicationLinkService, WhitelistRule whitelistRule) {
        this.applicationLinkService = (ReadOnlyApplicationLinkService)Preconditions.checkNotNull((Object)applicationLinkService, (Object)"applicationLinkService");
        this.whitelistRule = whitelistRule;
    }

    public boolean apply(URI uri) {
        Preconditions.checkNotNull((Object)this.whitelistRule, (Object)"whitelistRule");
        WhitelistType type = this.whitelistRule.getType();
        Function mapping = (Function)this.mappings.get((Object)type);
        if (mapping == null) {
            logger.debug("No mapping found for whitelist type '{}', ignoring data '{}'.", (Object)type, (Object)this.whitelistRule);
            return false;
        }
        try {
            return ((Predicate)mapping.apply((Object)this.whitelistRule)).apply((Object)uri);
        }
        catch (RuntimeException e) {
            logger.debug("Failed to match '{}' with whitelist rule '{}'", new Object[]{uri, this.whitelistRule, e});
            return false;
        }
    }

    private Function<WhitelistRule, Predicate<URI>> createApplicationLinkRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                String applicationId = input.getExpression();
                ReadOnlyApplicationLink applicationLink = DefaultWhitelistRuleMatcher.this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId));
                if (applicationLink == null) {
                    throw new IllegalArgumentException("Failed to resolved application link with application id '" + applicationId + "'; may be it has been removed and the whitelist was not updated?");
                }
                return this.createWhitelistRule(applicationLink);
            }

            private Predicate<URI> createWhitelistRule(ReadOnlyApplicationLink applicationLink) {
                return new ApplicationLinkMatcher(applicationLink);
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createExactUrlRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new ExactUrlMatcher(input.getExpression());
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createWildcardExpressionRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new WildcardExpressionMatcher(input.getExpression());
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createRegularExpressionRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new RegularExpressionMatcher(input.getExpression());
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createDomainNameRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new DomainNameMatcher(input.getExpression());
            }
        };
    }
}

