/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.plugins.whitelist.Whitelist;
import com.atlassian.plugins.whitelist.WhitelistOnOffSwitch;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.core.DefaultWhitelistRuleMatcher;
import com.atlassian.plugins.whitelist.core.matcher.SelfUrlMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import javax.annotation.Nullable;

abstract class AbstractWhitelist
implements Whitelist {
    private final WhitelistOnOffSwitch whitelistOnOffSwitch;
    private final WhitelistService whitelistService;
    private final SelfUrlMatcher selfUrlMatcher;
    private final ReadOnlyApplicationLinkService applicationLinkService;

    public AbstractWhitelist(WhitelistOnOffSwitch whitelistOnOffSwitch, WhitelistService whitelistService, SelfUrlMatcher selfUrlMatcher, ReadOnlyApplicationLinkService applicationLinkService) {
        this.whitelistOnOffSwitch = whitelistOnOffSwitch;
        this.whitelistService = whitelistService;
        this.selfUrlMatcher = selfUrlMatcher;
        this.applicationLinkService = applicationLinkService;
    }

    public boolean isAllowed(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        return this.isWhitelistDisabled() || this.selfUrlMatcher.apply(uri) || this.ruleMatchingUrlExists(uri);
    }

    private boolean isWhitelistDisabled() {
        return !this.whitelistOnOffSwitch.isEnabled();
    }

    private boolean ruleMatchingUrlExists(URI uri) {
        return Iterables.find((Iterable)this.whitelistService.getAll(), this.matchesUrl(uri), null) != null;
    }

    private Predicate<WhitelistRule> matchesUrl(final URI uri) {
        return new Predicate<WhitelistRule>(){

            public boolean apply(@Nullable WhitelistRule input) {
                return input != null && AbstractWhitelist.this.matches(input, uri);
            }
        };
    }

    protected boolean matches(WhitelistRule whitelistRule, URI uri) {
        return new DefaultWhitelistRuleMatcher(this.applicationLinkService, whitelistRule).apply(uri);
    }
}

