/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.wadl.resourcedoc;

import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.SelfExpandingExpander;
import com.atlassian.plugins.rest.common.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.ChainingEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.CollectionEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.ExpandConstraintEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.IdentityEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.ListWrapperEntityExpanderResolver;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.AnnotationDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ClassDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.MethodDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.NamedValueType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ParamDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.RepresentationDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.RequestDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResourceDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResponseDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.WadlParamType;
import com.sun.jersey.wadl.resourcedoc.DocProcessor;
import com.sun.jersey.wadl.resourcedoc.DocProcessorWrapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.jackson.map.Module;
import org.xml.sax.ContentHandler;

public class ResourceDocletJSON {
    private static final Pattern PATTERN_RESPONSE_REPRESENATION = Pattern.compile("@response\\.representation\\.([\\d]+)\\..*");
    private static final String OPTION_OUTPUT = "-output";
    private static final String OPTION_CLASSPATH = "-classpath";
    private static final String OPTION_DOC_PROCESSORS = "-processors";
    private static final Logger LOG = Logger.getLogger(ResourceDocletJSON.class.getName());
    private static final String OPTION_EXPAND = "-expand";
    private static final String OPTION_MODULES = "-modules";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc root) {
        String output = ResourceDocletJSON.getOptionArg(root.options(), OPTION_OUTPUT);
        String classpath = ResourceDocletJSON.getOptionArg(root.options(), OPTION_CLASSPATH);
        String[] classpathElements = classpath.split(":");
        String expandString = ResourceDocletJSON.getOptionArg(root.options(), OPTION_EXPAND);
        List<String> expand = Collections.emptyList();
        if (expandString != null) {
            expand = Arrays.asList(StringUtils.split(expandString, '&'));
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Loader ncl = new Loader(classpathElements, ResourceDocletJSON.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(ncl);
        String docProcessorOption = ResourceDocletJSON.getOptionArg(root.options(), OPTION_DOC_PROCESSORS);
        String[] docProcessors = docProcessorOption != null ? docProcessorOption.split(":") : new String[]{};
        DocProcessorWrapper docProcessor = new DocProcessorWrapper();
        for (String processorName : docProcessors) {
            try {
                Class<?> clazz = Class.forName(processorName, true, Thread.currentThread().getContextClassLoader());
                Class<DocProcessor> dpClazz = clazz.asSubclass(DocProcessor.class);
                docProcessor.add(dpClazz.newInstance());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not load docProcessor " + processorName, e);
            }
        }
        String moduleOption = ResourceDocletJSON.getOptionArg(root.options(), OPTION_MODULES);
        String[] moduleNames = moduleOption != null ? moduleOption.split(":") : new String[]{};
        ImmutableList.Builder modulesBuilder = ImmutableList.builder();
        for (String moduleName : moduleNames) {
            try {
                Class<?> clazz = Class.forName(moduleName, true, ncl);
                Class<Module> moduleClass = clazz.asSubclass(Module.class);
                Module module = moduleClass.newInstance();
                modulesBuilder.add((Object)module);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not load module " + moduleName, e);
            }
        }
        ImmutableList modules = modulesBuilder.build();
        try {
            ClassDoc[] classes;
            ResourceDocType result = new ResourceDocType();
            for (ClassDoc classDoc : classes = root.classes()) {
                LOG.fine("Writing class " + classDoc.qualifiedTypeName());
                ClassDocType classDocType = new ClassDocType();
                classDocType.setClassName(classDoc.qualifiedTypeName());
                classDocType.setCommentText(classDoc.commentText());
                docProcessor.processClassDoc(classDoc, classDocType);
                for (MethodDoc methodDoc : classDoc.methods()) {
                    MethodDocType methodDocType = new MethodDocType();
                    methodDocType.setMethodName(methodDoc.name());
                    methodDocType.setCommentText(methodDoc.commentText());
                    docProcessor.processMethodDoc(methodDoc, methodDocType);
                    ResourceDocletJSON.addParamDocs(methodDoc, methodDocType, docProcessor);
                    ResourceDocletJSON.addRequestRepresentationDoc(methodDoc, methodDocType, expand, (List<Module>)modules);
                    ResourceDocletJSON.addResponseDoc(methodDoc, methodDocType, expand, (List<Module>)modules);
                    classDocType.getMethodDocs().add(methodDocType);
                }
                result.getDocs().add(classDocType);
            }
            try {
                Class[] clazzes = ResourceDocletJSON.getJAXBContextClasses(result, docProcessor);
                JAXBContext c = JAXBContext.newInstance((Class[])clazzes);
                Marshaller m = c.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output));
                String[] cdataElements = ResourceDocletJSON.getCDataElements(docProcessor);
                XMLSerializer serializer = ResourceDocletJSON.getXMLSerializer(out, cdataElements);
                m.marshal((Object)result, (ContentHandler)serializer);
                ((OutputStream)out).close();
                LOG.info("Wrote " + output);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not serialize ResourceDoc.", e);
                boolean bl = false;
                Thread.currentThread().setContextClassLoader(cl);
                return bl;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return true;
    }

    private static String[] getCDataElements(DocProcessor docProcessor) {
        String[] original = new String[]{"ns1^commentText", "ns2^commentText", "^commentText"};
        if (docProcessor == null) {
            return original;
        }
        String[] cdataElements = docProcessor.getCDataElements();
        if (cdataElements == null || cdataElements.length == 0) {
            return original;
        }
        String[] result = (String[])ResourceDocletJSON.copyOf(original, original.length + cdataElements.length);
        for (int i = 0; i < cdataElements.length; ++i) {
            result[original.length + i] = cdataElements[i];
        }
        return result;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength) {
        Object[] copy = original.getClass() == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(original.getClass().getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static Class<?>[] getJAXBContextClasses(ResourceDocType result, DocProcessor docProcessor) {
        Class[] clazzes;
        if (docProcessor == null) {
            clazzes = new Class[1];
        } else {
            Class<?>[] requiredJaxbContextClasses = docProcessor.getRequiredJaxbContextClasses();
            if (requiredJaxbContextClasses != null) {
                clazzes = new Class[1 + requiredJaxbContextClasses.length];
                for (int i = 0; i < requiredJaxbContextClasses.length; ++i) {
                    clazzes[i + 1] = requiredJaxbContextClasses[i];
                }
            } else {
                clazzes = new Class[]{result.getClass()};
            }
        }
        return clazzes;
    }

    private static XMLSerializer getXMLSerializer(OutputStream os, String[] cdataElements) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(cdataElements);
        of.setPreserveSpace(true);
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(os);
        return serializer;
    }

    private static void addResponseDoc(MethodDoc methodDoc, MethodDocType methodDocType, Collection<String> expand, List<Module> modules) {
        Tag[] responseParamTags;
        ResponseDocType responseDoc = new ResponseDocType();
        Tag returnTag = ResourceDocletJSON.getSingleTagOrNull(methodDoc, "return");
        if (returnTag != null) {
            responseDoc.setReturnDoc(returnTag.text());
        }
        for (Tag responseParamTag : responseParamTags = methodDoc.tags("response.param")) {
            WadlParamType wadlParam = new WadlParamType();
            for (Tag inlineTag : responseParamTag.inlineTags()) {
                String tagName = inlineTag.name();
                String tagText = inlineTag.text();
                if (ResourceDocletJSON.isEmpty(tagText)) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Skipping empty inline tag of @response.param in method " + methodDoc.qualifiedName() + ": " + tagName);
                    continue;
                }
                if ("@name".equals(tagName)) {
                    wadlParam.setName(tagText);
                    continue;
                }
                if ("@style".equals(tagName)) {
                    wadlParam.setStyle(tagText);
                    continue;
                }
                if ("@type".equals(tagName)) {
                    wadlParam.setType(QName.valueOf(tagText));
                    continue;
                }
                if ("@doc".equals(tagName)) {
                    wadlParam.setDoc(tagText);
                    continue;
                }
                LOG.warning("Unknown inline tag of @response.param in method " + methodDoc.qualifiedName() + ": " + tagName + " (value: " + tagText + ")");
            }
            responseDoc.getWadlParams().add(wadlParam);
        }
        Map<String, List<Tag>> tagsByStatus = ResourceDocletJSON.getResponseRepresentationTags(methodDoc);
        for (Map.Entry<String, List<Tag>> entry : tagsByStatus.entrySet()) {
            RepresentationDocType representationDoc = new RepresentationDocType();
            representationDoc.setStatus(Long.valueOf(entry.getKey()));
            for (Tag tag : entry.getValue()) {
                if (tag.name().endsWith(".qname")) {
                    representationDoc.setElement(QName.valueOf(tag.text()));
                    continue;
                }
                if (tag.name().endsWith(".mediaType")) {
                    representationDoc.setMediaType(tag.text());
                    continue;
                }
                if (tag.name().endsWith(".example")) {
                    representationDoc.setExample(ResourceDocletJSON.getSerializedExample(tag, expand, modules));
                    continue;
                }
                if (tag.name().endsWith(".doc")) {
                    representationDoc.setDoc(tag.text());
                    continue;
                }
                LOG.warning("Unknown response representation tag " + tag.name());
            }
            responseDoc.getRepresentations().add(representationDoc);
        }
        methodDocType.setResponseDoc(responseDoc);
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    private static void addRequestRepresentationDoc(MethodDoc methodDoc, MethodDocType methodDocType, Collection<String> expand, List<Module> modules) {
        Tag requestElement = ResourceDocletJSON.getSingleTagOrNull(methodDoc, "request.representation.qname");
        Tag requestExample = ResourceDocletJSON.getSingleTagOrNull(methodDoc, "request.representation.example");
        if (requestElement != null || requestExample != null) {
            RequestDocType requestDoc = new RequestDocType();
            RepresentationDocType representationDoc = new RepresentationDocType();
            if (requestElement != null) {
                representationDoc.setElement(QName.valueOf(requestElement.text()));
            }
            if (requestExample != null) {
                String example = ResourceDocletJSON.getSerializedExample(requestExample, expand, modules);
                if (!ResourceDocletJSON.isEmpty(example)) {
                    representationDoc.setExample(example);
                } else {
                    LOG.warning("Could not get serialized example for method " + methodDoc.qualifiedName());
                }
            }
            requestDoc.setRepresentationDoc(representationDoc);
            methodDocType.setRequestDoc(requestDoc);
        }
    }

    private static Map<String, List<Tag>> getResponseRepresentationTags(MethodDoc methodDoc) {
        HashMap<String, List<Tag>> tagsByStatus = new HashMap<String, List<Tag>>();
        for (Tag tag : methodDoc.tags()) {
            Matcher matcher = PATTERN_RESPONSE_REPRESENATION.matcher(tag.name());
            if (!matcher.matches()) continue;
            String status = matcher.group(1);
            ArrayList<Tag> tags = (ArrayList<Tag>)tagsByStatus.get(status);
            if (tags == null) {
                tags = new ArrayList<Tag>();
                tagsByStatus.put(status, tags);
            }
            tags.add(tag);
        }
        return tagsByStatus;
    }

    private static String getSerializedExample(Tag tag, Collection<String> expand, List<Module> modules) {
        if (tag != null) {
            Tag[] inlineTags = tag.inlineTags();
            if (inlineTags != null && inlineTags.length > 0) {
                for (Tag inlineTag : inlineTags) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Have inline tag: " + ResourceDocletJSON.print(inlineTag));
                    }
                    if ("@link".equals(inlineTag.name())) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Have link: " + ResourceDocletJSON.print(inlineTag));
                        }
                        SeeTag linkTag = (SeeTag)inlineTag;
                        return ResourceDocletJSON.getSerializedLinkFromTag(linkTag, expand, modules);
                    }
                    if (ResourceDocletJSON.isEmpty(inlineTag.text())) continue;
                    return inlineTag.text();
                }
            } else {
                LOG.fine("Have example: " + ResourceDocletJSON.print(tag));
                return tag.text();
            }
        }
        return null;
    }

    private static Tag getSingleTagOrNull(MethodDoc methodDoc, String tagName) {
        Tag[] tags = methodDoc.tags(tagName);
        if (tags != null && tags.length == 1) {
            return tags[0];
        }
        return null;
    }

    private static void addParamDocs(MethodDoc methodDoc, MethodDocType methodDocType, DocProcessor docProcessor) {
        final Parameter[] parameters = methodDoc.parameters();
        final ParamTag[] paramTags = methodDoc.paramTags();
        if (parameters != null && paramTags != null) {
            HashMap<String, Parameter> params = new HashMap<String, Parameter>(parameters.length){
                {
                    super(x0);
                    for (Parameter parameter : parameters) {
                        this.put(parameter.name(), parameter);
                    }
                }
            };
            HashMap<String, ParamTag> tags = new HashMap<String, ParamTag>(parameters.length){
                {
                    super(x0);
                    for (ParamTag paramTag : paramTags) {
                        this.put(paramTag.parameterName(), paramTag);
                    }
                }
            };
            for (Map.Entry parameterEntry : params.entrySet()) {
                Parameter parameter = (Parameter)parameterEntry.getValue();
                ParamTag paramTag = (ParamTag)tags.get(parameterEntry.getKey());
                if (paramTag == null) continue;
                ParamDocType paramDocType = new ParamDocType();
                paramDocType.setParamName(paramTag.parameterName());
                paramDocType.setCommentText(paramTag.parameterComment());
                docProcessor.processParamTag(paramTag, parameter, paramDocType);
                AnnotationDesc[] annotations = parameter.annotations();
                if (annotations != null) {
                    for (AnnotationDesc annotationDesc : annotations) {
                        AnnotationDocType annotationDocType = new AnnotationDocType();
                        String typeName = annotationDesc.annotationType().qualifiedName();
                        annotationDocType.setAnnotationTypeName(typeName);
                        for (AnnotationDesc.ElementValuePair elementValuePair : annotationDesc.elementValues()) {
                            NamedValueType namedValueType = new NamedValueType();
                            namedValueType.setName(elementValuePair.element().name());
                            namedValueType.setValue(elementValuePair.value().value().toString());
                            annotationDocType.getAttributeDocs().add(namedValueType);
                        }
                        paramDocType.getAnnotationDocs().add(annotationDocType);
                    }
                }
                methodDocType.getParamDocs().add(paramDocType);
            }
        }
    }

    private static String getSerializedLinkFromTag(SeeTag linkTag, Collection<String> expand, List<Module> modules) {
        Object object;
        MemberDoc referencedMember = linkTag.referencedMember();
        if (referencedMember == null) {
            LOG.warning("Referenced member of @link " + ResourceDocletJSON.print((Tag)linkTag) + " cannot be resolved.");
            return null;
        }
        if (!referencedMember.isStatic()) {
            LOG.warning("Referenced member of @link " + ResourceDocletJSON.print((Tag)linkTag) + " is not static." + " Right now only references to static members are supported.");
            return null;
        }
        ClassDoc containingClass = referencedMember.containingClass();
        try {
            Field declaredField = Class.forName(containingClass.qualifiedName(), false, Thread.currentThread().getContextClassLoader()).getDeclaredField(referencedMember.name());
            if (referencedMember.isFinal()) {
                declaredField.setAccessible(true);
            }
            object = declaredField.get(null);
            LOG.log(Level.FINE, "Got object " + object);
        }
        catch (Exception e) {
            LOG.info("Have classloader: " + ResourceDocletJSON.class.getClassLoader().getClass());
            LOG.info("Have thread classloader " + Thread.currentThread().getContextClassLoader().getClass());
            LOG.info("Have system classloader " + ClassLoader.getSystemClassLoader().getClass());
            LOG.log(Level.SEVERE, "Could not get field " + referencedMember.qualifiedName(), e);
            return null;
        }
        try {
            return ResourceDocletJSON.marshallBean(object, expand, modules);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could serialize bean to xml: " + object, e);
            return null;
        }
    }

    private static String marshallBean(Object object, Collection<String> expand, List<Module> modules) throws JAXBException, IOException {
        if (!expand.isEmpty()) {
            new EntityCrawler().crawl(object, new DefaultExpandParameter(expand), ResourceDocletJSON.getExpanders());
        }
        JaxbJsonMarshaller m = DefaultJaxbJsonMarshaller.builder().modules(modules).build();
        String result = m.marshal(object);
        LOG.log(Level.FINE, "Got marshalled output:\n" + result);
        return result;
    }

    private static String print(Tag tag) {
        StringBuilder sb = new StringBuilder();
        sb.append(tag.getClass()).append("[");
        sb.append("firstSentenceTags=").append(ResourceDocletJSON.toCSV(tag.firstSentenceTags()));
        sb.append(", inlineTags=").append(ResourceDocletJSON.toCSV(tag.inlineTags()));
        sb.append(", kind=").append(tag.kind());
        sb.append(", name=").append(tag.name());
        sb.append(", text=").append(tag.text());
        sb.append("]");
        return sb.toString();
    }

    static <T> String toCSV(Tag[] items) {
        if (items == null) {
            return null;
        }
        return ResourceDocletJSON.toCSV(Arrays.asList(items));
    }

    static <I> String toCSV(Collection<Tag> items) {
        return ResourceDocletJSON.toCSV(items, ", ", null);
    }

    static <I> String toCSV(Collection<Tag> items, String separator, String delimiter) {
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Tag> iter = items.iterator();
        while (iter.hasNext()) {
            if (delimiter != null) {
                sb.append(delimiter);
            }
            Tag item = iter.next();
            sb.append(item.name());
            if (delimiter != null) {
                sb.append(delimiter);
            }
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static int optionLength(String option) {
        LOG.fine("Invoked with option " + option);
        if (OPTION_OUTPUT.equals(option) || OPTION_CLASSPATH.equals(option) || OPTION_DOC_PROCESSORS.equals(option) || OPTION_EXPAND.equals(option) || OPTION_MODULES.equals(option)) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return ResourceDocletJSON.validOption(OPTION_OUTPUT, "<path-to-file>", options, reporter) && ResourceDocletJSON.validOption(OPTION_CLASSPATH, "<path>", options, reporter) && ResourceDocletJSON.validOptionalOption(OPTION_DOC_PROCESSORS, options) && ResourceDocletJSON.validOptionalOption(OPTION_EXPAND, options) && ResourceDocletJSON.validOptionalOption(OPTION_MODULES, options);
    }

    private static boolean validOption(String optionName, String reportOptionName, String[][] options, DocErrorReporter reporter) {
        boolean foundOption;
        String option = ResourceDocletJSON.getOptionArg(options, optionName);
        boolean bl = foundOption = option != null && option.trim().length() > 0;
        if (!foundOption) {
            reporter.printError(optionName + " " + reportOptionName + " must be specified.");
        }
        return foundOption;
    }

    private static boolean validOptionalOption(String optionName, String[][] options) {
        String option = ResourceDocletJSON.getOptionArg(options, optionName);
        return option == null || option.trim().length() > 0;
    }

    private static String getOptionArg(String[][] options, String option) {
        for (int i = 0; i < options.length; ++i) {
            String[] opt = options[i];
            if (!opt[0].equals(option)) continue;
            return opt[1];
        }
        return null;
    }

    private static EntityExpanderResolver getExpanders() {
        return new ChainingEntityExpanderResolver(Lists.newArrayList((Object[])new EntityExpanderResolver[]{new CollectionEntityExpanderResolver(), new ListWrapperEntityExpanderResolver(), new ExpandConstraintEntityExpanderResolver(), new SelfExpandingExpander.Resolver(), new IdentityEntityExpanderResolver()}));
    }

    static class Loader
    extends URLClassLoader {
        public Loader(String[] paths, ClassLoader parent) {
            super(Loader.getURLs(paths), parent);
        }

        Loader(String[] paths) {
            super(Loader.getURLs(paths));
        }

        private static URL[] getURLs(String[] paths) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            URL[] us = urls.toArray(new URL[0]);
            return us;
        }
    }
}

