/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.filter;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;

@Provider
public class AcceptHeaderJerseyMvcFilter
implements ContainerRequestFilter {
    static final Set<String> ACCEPTED_CONTENT_TYPES = new HashSet<String>(){
        {
            this.add("text/plain");
            this.add("text/html");
            this.add("text/html");
            this.add("application/json");
            this.add("application/xml");
            this.add("application/atom+xml");
        }
    };

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        MultivaluedMap<String, String> requestHeaders = request.getRequestHeaders();
        String acceptHeader = requestHeaders.getFirst("Accept");
        String fixedHeader = this.addAppXmlWhenWildcardOnly(acceptHeader);
        fixedHeader = this.moveTextHtmlToFront(fixedHeader);
        if (acceptHeader != null && !acceptHeader.equals(fixedHeader)) {
            requestHeaders.putSingle("Accept", fixedHeader);
        }
        return request;
    }

    private String addAppXmlWhenWildcardOnly(String acceptHeader) {
        if (StringUtils.contains(acceptHeader, "*/*")) {
            for (String contentType : ACCEPTED_CONTENT_TYPES) {
                if (!StringUtils.contains(acceptHeader, contentType)) continue;
                return acceptHeader;
            }
            return "application/xml," + acceptHeader;
        }
        return acceptHeader;
    }

    private String moveTextHtmlToFront(String acceptHeader) {
        if ((StringUtils.contains(acceptHeader, "text/html") || StringUtils.contains(acceptHeader, "*/*")) && !StringUtils.startsWith(acceptHeader, "text/html")) {
            return "text/html," + acceptHeader;
        }
        return acceptHeader;
    }
}

