/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet.user;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class IconUriServlet
extends HttpServlet {
    private final RequestFactory<Request<?, ?>> requestFactory;

    public IconUriServlet(RequestFactory<Request<?, ?>> requestFactory) {
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull(requestFactory, (Object)"requestFactory");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String consumerUri = req.getParameter("consumerUri");
        if (StringUtils.isEmpty((String)consumerUri)) {
            resp.sendError(400);
        } else {
            IconUriResponseHandler responseHandler = new IconUriResponseHandler(resp);
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, consumerUri);
            request.setHeader("Accept", "text/html");
            try {
                request.execute((ResponseHandler)responseHandler);
            }
            catch (ResponseException e) {
                resp.sendError(500, e.getMessage());
            }
        }
    }

    private static class IconUriResponseHandler
    implements ResponseHandler {
        private final HttpServletResponse resp;

        public IconUriResponseHandler(HttpServletResponse resp) {
            this.resp = resp;
        }

        public void handle(Response response) throws ResponseException {
            if (response.getStatusCode() != 200) {
                throw new ResponseException("Server responded with an error");
            }
            try {
                IOUtils.copy((InputStream)response.getResponseBodyAsStream(), (OutputStream)this.resp.getOutputStream());
                this.resp.setStatus(response.getStatusCode());
                this.resp.setContentType("text/html");
                IOUtils.closeQuietly((OutputStream)this.resp.getOutputStream());
            }
            catch (IOException e) {
                throw new ResponseException((Throwable)e);
            }
        }
    }
}

