/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet.authorize;

import com.atlassian.oauth.serviceprovider.ConsumerInformationRenderException;
import com.atlassian.oauth.serviceprovider.ConsumerInformationRenderer;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.serviceprovider.internal.servlet.authorize.AuthorizationRenderer;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;

public final class AuthorizationRendererImpl
implements AuthorizationRenderer {
    private final TemplateRenderer renderer;
    private final Iterable<ConsumerInformationRenderer> consumerInfoRenderers;
    private final ConsumerInformationRenderer basicConsumerInformationRenderer;
    private final ApplicationProperties applicationProperties;

    public AuthorizationRendererImpl(ApplicationProperties applicationProperties, TemplateRenderer renderer, Iterable<ConsumerInformationRenderer> consumerInfoRenderers, @Qualifier(value="basicConsumerInformationRenderer") ConsumerInformationRenderer basicConsumerInformationRenderer) {
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.consumerInfoRenderers = (Iterable)Preconditions.checkNotNull(consumerInfoRenderers, (Object)"consumerInfoRenderers");
        this.basicConsumerInformationRenderer = (ConsumerInformationRenderer)Preconditions.checkNotNull((Object)basicConsumerInformationRenderer, (Object)"basicConsumerInformationRenderer");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    @Override
    public void render(HttpServletRequest request, HttpServletResponse response, ServiceProviderToken token) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        ConsumerInformationRenderer consumerInfoRenderer = this.findConsumerInfoRenderer(request, token);
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"applicationProperties", (Object)this.applicationProperties);
        contextBuilder.put((Object)"token", (Object)token.getToken());
        contextBuilder.put((Object)"consumer", (Object)token.getConsumer());
        contextBuilder.put((Object)"consumerRenderer", (Object)new AuthorizationConsumerRenderer(consumerInfoRenderer, token, request, response.getWriter()));
        contextBuilder.put((Object)"accessTokensAdminUri", (Object)(this.applicationProperties.getBaseUrl() + "/plugins/servlet/oauth/users/access-tokens"));
        String callback = request.getParameter("oauth_callback");
        if (callback != null) {
            contextBuilder.put((Object)"callback", (Object)callback);
        }
        try {
            this.renderer.render("templates/auth/authorize.vm", (Map)contextBuilder.build(), (Writer)response.getWriter());
        }
        catch (RenderingException e) {
            throw new ConsumerInformationRenderException("Could not render consumer information", (Throwable)e);
        }
    }

    private ConsumerInformationRenderer findConsumerInfoRenderer(HttpServletRequest request, ServiceProviderToken token) {
        try {
            return new DynamicSafeConsumerInformationRenderer((ConsumerInformationRenderer)Iterables.find(this.consumerInfoRenderers, AuthorizationRendererImpl.canRender(token, request)), this.basicConsumerInformationRenderer);
        }
        catch (NoSuchElementException e) {
            return this.basicConsumerInformationRenderer;
        }
    }

    private static final Predicate<ConsumerInformationRenderer> canRender(ServiceProviderToken token, HttpServletRequest request) {
        return new CanRender(token, request);
    }

    private static class CanRender
    implements Predicate<ConsumerInformationRenderer> {
        private final ServiceProviderToken token;
        private final HttpServletRequest request;

        public CanRender(ServiceProviderToken token, HttpServletRequest request) {
            this.token = token;
            this.request = request;
        }

        public boolean apply(ConsumerInformationRenderer renderer) {
            return renderer.canRender(this.token, this.request);
        }
    }

    private static final class DynamicSafeConsumerInformationRenderer
    implements ConsumerInformationRenderer {
        private final ConsumerInformationRenderer dynamicRenderer;
        private final ConsumerInformationRenderer fallbackRenderer;

        public DynamicSafeConsumerInformationRenderer(ConsumerInformationRenderer dynamicRenderer, ConsumerInformationRenderer fallbackRenderer) {
            this.dynamicRenderer = dynamicRenderer;
            this.fallbackRenderer = fallbackRenderer;
        }

        public boolean canRender(ServiceProviderToken token, HttpServletRequest request) {
            return true;
        }

        public void render(ServiceProviderToken token, HttpServletRequest request, Writer writer) throws IOException {
            try {
                this.dynamicRenderer.render(token, request, writer);
            }
            catch (RuntimeException e) {
                if (e.getClass().getSimpleName().equals("ServiceUnavailableException")) {
                    this.fallbackRenderer.render(token, request, writer);
                }
                throw e;
            }
        }
    }

    private static final class AuthorizationConsumerRenderer
    implements Renderable {
        private final ConsumerInformationRenderer renderer;
        private final ServiceProviderToken token;
        private final HttpServletRequest request;
        private final PrintWriter writer;

        public AuthorizationConsumerRenderer(ConsumerInformationRenderer renderer, ServiceProviderToken token, HttpServletRequest request, PrintWriter writer) {
            this.renderer = renderer;
            this.token = token;
            this.request = request;
            this.writer = writer;
        }

        @Override
        public final void render() throws IOException {
            this.renderer.render(this.token, this.request, (Writer)this.writer);
        }
    }

    public static interface Renderable {
        public void render() throws IOException;
    }
}

