/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal;

import com.atlassian.oauth.serviceprovider.ServiceProviderTokenStore;
import com.atlassian.oauth.serviceprovider.internal.ExpiredSessionRemover;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobHandlerKey;
import java.util.Date;
import org.springframework.beans.factory.annotation.Qualifier;

public final class ExpiredSessionRemoverScheduler
implements LifecycleAware {
    private static final long EIGHT_HOURS = 28800000L;
    private static final String HANDLER_KEY = "Service Provider Session Remover";
    private final ServiceProviderTokenStore store;
    private final CompatibilityPluginScheduler pluginScheduler;

    public ExpiredSessionRemoverScheduler(@Qualifier(value="tokenStore") ServiceProviderTokenStore store, CompatibilityPluginScheduler pluginScheduler) {
        this.store = store;
        this.pluginScheduler = pluginScheduler;
    }

    public void onStart() {
        JobHandlerKey handlerKey = JobHandlerKey.of((String)HANDLER_KEY);
        this.pluginScheduler.registerJobHandler(handlerKey, (JobHandler)new ExpiredSessionRemover(this.store));
        this.pluginScheduler.scheduleClusteredJob(handlerKey.toString(), handlerKey, new Date(System.currentTimeMillis() + 28800000L), 28800000L);
    }

    public void onStop() {
        JobHandlerKey handlerKey = JobHandlerKey.of((String)HANDLER_KEY);
        this.pluginScheduler.unregisterJobHandler(handlerKey);
        this.pluginScheduler.unscheduleClusteredJob(handlerKey.toString());
    }
}

