/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal;

import com.atlassian.oauth.Request;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.serviceprovider.TokenPropertiesFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public final class AggregateTokenPropertiesFactory
implements TokenPropertiesFactory {
    private final Iterable<TokenPropertiesFactory> propertyFactories;

    public AggregateTokenPropertiesFactory(Iterable<TokenPropertiesFactory> propertyFactories) {
        this.propertyFactories = (Iterable)Preconditions.checkNotNull(propertyFactories, (Object)"propertyFactories");
    }

    public Map<String, String> newRequestTokenProperties(Request request) {
        HashMap properties = Maps.newHashMap();
        for (TokenPropertiesFactory propertiesFactory : this.propertyFactories) {
            try {
                properties.putAll(propertiesFactory.newRequestTokenProperties(request));
            }
            catch (RuntimeException e) {
                if (e.getClass().getSimpleName().equals("ServiceUnavailableException")) continue;
                throw e;
            }
        }
        return ImmutableMap.copyOf((Map)properties);
    }

    public Map<String, String> newAccessTokenProperties(ServiceProviderToken requestToken) {
        HashMap properties = Maps.newHashMap();
        for (TokenPropertiesFactory propertiesFactory : this.propertyFactories) {
            try {
                properties.putAll(propertiesFactory.newAccessTokenProperties(requestToken));
            }
            catch (RuntimeException e) {
                if (e.getClass().getSimpleName().equals("ServiceUnavailableException")) continue;
                throw e;
            }
        }
        return ImmutableMap.copyOf((Map)properties);
    }
}

