/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerCreationException;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.consumer.core.HostConsumerAndSecretProvider;
import com.atlassian.oauth.consumer.sal.ConsumerProperties;
import com.atlassian.oauth.consumer.sal.KeyPairFactory;
import com.atlassian.oauth.shared.sal.PrefixingPluginSettings;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Properties;
import java.util.Random;

public class PluginSettingsHostConsumerAndSecretProviderImpl
implements HostConsumerAndSecretProvider {
    static final String HOST_SERVICENAME = "__HOST_SERVICE__";
    private final ApplicationProperties applicationProperties;
    private final KeyPairFactory keyPairFactory;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final I18nResolver i18n;

    public PluginSettingsHostConsumerAndSecretProviderImpl(ApplicationProperties applicationProperties, PluginSettingsFactory pluginSettingsFactory, KeyPairFactory keyPairFactory, I18nResolver i18nResolver) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.keyPairFactory = (KeyPairFactory)Preconditions.checkNotNull((Object)keyPairFactory, (Object)"keyPairFactory");
        this.i18n = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    public synchronized ConsumerServiceStore.ConsumerAndSecret get() {
        Settings settings = this.settings();
        ConsumerServiceStore.ConsumerAndSecret hostCas = settings.get();
        if (hostCas != null) {
            return hostCas;
        }
        hostCas = this.createHostConsumerAndSecret();
        settings.put(hostCas);
        return hostCas;
    }

    public ConsumerServiceStore.ConsumerAndSecret put(ConsumerServiceStore.ConsumerAndSecret hostCas) {
        Settings settings = this.settings();
        settings.put(hostCas);
        return settings.get();
    }

    private ConsumerServiceStore.ConsumerAndSecret createHostConsumerAndSecret() {
        KeyPair keyPair;
        String key = this.generateConsumerKey();
        try {
            keyPair = this.keyPairFactory.newKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new ConsumerCreationException("Could not create key pair for consumer", (Throwable)e);
        }
        Consumer consumer = Consumer.key((String)key).name(this.applicationProperties.getDisplayName()).publicKey(keyPair.getPublic()).description(this.i18n.getText("host.consumer.default.description", new Serializable[]{this.applicationProperties.getDisplayName(), this.applicationProperties.getBaseUrl()})).build();
        return new ConsumerServiceStore.ConsumerAndSecret(HOST_SERVICENAME, consumer, keyPair.getPrivate());
    }

    private String generateConsumerKey() {
        String key = this.applicationProperties.getDisplayName() + ":";
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            key = key + random.nextInt(10);
        }
        return key;
    }

    private Settings settings() {
        return new Settings(this.pluginSettingsFactory.createGlobalSettings());
    }

    final class Settings {
        private PluginSettings settings;

        public Settings(PluginSettings settings) {
            this.settings = new PrefixingPluginSettings((PluginSettings)Preconditions.checkNotNull((Object)settings, (Object)"settings"), ConsumerService.class.getName() + ":host");
        }

        public ConsumerServiceStore.ConsumerAndSecret get() {
            Properties props = (Properties)this.settings.get(PluginSettingsHostConsumerAndSecretProviderImpl.HOST_SERVICENAME);
            if (props == null) {
                return null;
            }
            return new ConsumerProperties(props).asConsumerAndSecret(PluginSettingsHostConsumerAndSecretProviderImpl.HOST_SERVICENAME);
        }

        public void put(ConsumerServiceStore.ConsumerAndSecret cas) {
            this.settings.put(PluginSettingsHostConsumerAndSecretProviderImpl.HOST_SERVICENAME, (Object)new ConsumerProperties(cas).asProperties());
        }
    }
}

