/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.Token;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.oauth.consumer.ConsumerTokenStore;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.consumer.core.HostConsumerAndSecretProvider;
import com.atlassian.oauth.shared.sal.Functions;
import com.atlassian.oauth.shared.sal.HashingLongPropertyKeysPluginSettings;
import com.atlassian.oauth.shared.sal.PrefixingPluginSettings;
import com.atlassian.oauth.shared.sal.TokenProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;

public class PluginSettingsConsumerTokenStore
implements ConsumerTokenStore {
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ConsumerServiceStore consumerServiceStore;
    private final HostConsumerAndSecretProvider hostCasProvider;

    public PluginSettingsConsumerTokenStore(PluginSettingsFactory factory, ConsumerServiceStore consumerServiceStore, HostConsumerAndSecretProvider hostCasProvider) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        this.consumerServiceStore = (ConsumerServiceStore)Preconditions.checkNotNull((Object)consumerServiceStore, (Object)"consumerServiceStore");
        this.hostCasProvider = (HostConsumerAndSecretProvider)Preconditions.checkNotNull((Object)hostCasProvider, (Object)"hostCasProvider");
    }

    public ConsumerToken get(ConsumerTokenStore.Key key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        TokenProperties props = this.settings().get(key);
        if (props == null) {
            return null;
        }
        ConsumerServiceStore.ConsumerAndSecret cas = this.hostCasProvider.get();
        if (cas == null || !cas.getConsumer().getKey().equals(props.getConsumerKey())) {
            cas = this.consumerServiceStore.getByKey(props.getConsumerKey());
        }
        Preconditions.checkNotNull((Object)"consumerAndSecret", (Object)cas);
        Consumer consumer = cas.getConsumer();
        if (props.isAccessToken()) {
            return ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)ConsumerToken.newAccessToken((String)props.getToken()).tokenSecret(props.getTokenSecret())).consumer(consumer)).properties(props.getProperties())).build();
        }
        return ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)ConsumerToken.newRequestToken((String)props.getToken()).tokenSecret(props.getTokenSecret())).consumer(consumer)).properties(props.getProperties())).build();
    }

    public Map<ConsumerTokenStore.Key, ConsumerToken> getConsumerTokens(String consumerKey) {
        Preconditions.checkNotNull((Object)consumerKey, (Object)"consumerKey");
        ImmutableMap.Builder consumerTokens = ImmutableMap.builder();
        for (String tokenStr : this.settings().getTokensForConsumer(consumerKey)) {
            ConsumerTokenStore.Key key = new ConsumerTokenStore.Key(tokenStr);
            ConsumerToken token = this.get(key);
            if (token == null) continue;
            consumerTokens.put((Object)key, (Object)token);
        }
        return consumerTokens.build();
    }

    public ConsumerToken put(ConsumerTokenStore.Key key, ConsumerToken token) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)token, (Object)"token");
        Settings settings = this.settings();
        settings.put(key, new ConsumerTokenProperties(token));
        settings.addTokenForConsumer(token.getConsumer().getKey(), key);
        return token;
    }

    public void remove(ConsumerTokenStore.Key key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Settings settings = this.settings();
        TokenProperties properties = settings.get(key);
        if (properties == null) {
            return;
        }
        settings.remove(key);
        settings.removeTokenForConsumer(properties.getConsumerKey(), key);
    }

    public void removeTokensForConsumer(String consumerKey) {
        Preconditions.checkNotNull((Object)consumerKey, (Object)"consumerKey");
        Settings settings = this.settings();
        Set<String> tokens = settings.getTokensForConsumer(consumerKey);
        for (String token : tokens) {
            settings.remove(new ConsumerTokenStore.Key(token));
        }
        settings.removeTokensForConsumer(consumerKey);
    }

    private Settings settings() {
        return new Settings(this.pluginSettingsFactory.createGlobalSettings());
    }

    static final class ConsumerTokenProperties
    extends TokenProperties {
        public ConsumerTokenProperties(Properties properties) {
            super(properties);
        }

        public ConsumerTokenProperties(ConsumerToken token) {
            super((Token)token);
        }
    }

    static final class Settings {
        private final PluginSettings settings;

        Settings(PluginSettings settings) {
            this.settings = new PrefixingPluginSettings((PluginSettings)new HashingLongPropertyKeysPluginSettings(settings), ConsumerTokenStore.class.getName());
        }

        TokenProperties get(ConsumerTokenStore.Key key) {
            Properties props = (Properties)this.settings.get(this.tokenSettingKey(key));
            if (props == null) {
                return null;
            }
            return new ConsumerTokenProperties(props);
        }

        void put(ConsumerTokenStore.Key key, TokenProperties tokenProperties) {
            this.settings.put(this.tokenSettingKey(key), (Object)tokenProperties.asProperties());
        }

        void remove(ConsumerTokenStore.Key key) {
            this.settings.remove(this.tokenSettingKey(key));
        }

        private String tokenSettingKey(ConsumerTokenStore.Key key) {
            return "keys." + DigestUtils.shaHex((String)key.toString());
        }

        public Set<String> getTokensForConsumer(String consumerKey) {
            String tokenKeys = (String)this.settings.get(this.consumerSettingKey(consumerKey));
            if (tokenKeys == null) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(tokenKeys.split("/")), (Function)Functions.toDecodedKeys()));
        }

        private void putTokensForConsumer(String consumerKey, Iterable<String> tokens) {
            if (tokens.iterator().hasNext()) {
                this.settings.put(this.consumerSettingKey(consumerKey), (Object)Joiner.on((String)"/").join(Iterables.transform(tokens, (Function)Functions.toEncodedKeys())));
            } else {
                this.settings.put(this.consumerSettingKey(consumerKey), null);
            }
        }

        public void removeTokenForConsumer(String consumerKey, ConsumerTokenStore.Key tokenKey) {
            Set tokens = Sets.filter(this.getTokensForConsumer(consumerKey), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)tokenKey.toString())));
            this.putTokensForConsumer(consumerKey, tokens);
        }

        public void addTokenForConsumer(String consumerKey, ConsumerTokenStore.Key tokenKey) {
            this.putTokensForConsumer(consumerKey, (Iterable<String>)Sets.union((Set)ImmutableSet.of((Object)tokenKey.toString()), this.getTokensForConsumer(consumerKey)));
        }

        public void removeTokensForConsumer(String consumerKey) {
            this.settings.remove(this.consumerSettingKey(consumerKey));
        }

        private String consumerSettingKey(String consumerKey) {
            return "consumerKeys." + consumerKey;
        }
    }
}

