/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.consumer.sal.ConsumerProperties;
import com.atlassian.oauth.shared.sal.Functions;
import com.atlassian.oauth.shared.sal.HashingLongPropertyKeysPluginSettings;
import com.atlassian.oauth.shared.sal.PrefixingPluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class PluginSettingsConsumerServiceStore
implements ConsumerServiceStore {
    private final PluginSettingsFactory pluginSettingsFactory;

    public PluginSettingsConsumerServiceStore(PluginSettingsFactory factory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    public ConsumerServiceStore.ConsumerAndSecret get(String service) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        ConsumerProperties consumerProperties = this.settings().getConsumerProperties(service);
        if (consumerProperties == null) {
            return null;
        }
        return consumerProperties.asConsumerAndSecret(service);
    }

    public ConsumerServiceStore.ConsumerAndSecret getByKey(String consumerKey) {
        Preconditions.checkNotNull((Object)consumerKey, (Object)"consumerKey");
        String service = this.settings().getServiceNameForConsumerKey(consumerKey);
        if (service == null) {
            return null;
        }
        return this.get(service);
    }

    public Iterable<Consumer> getAllServiceProviders() {
        return Iterables.transform(this.settings().getServiceNames(), (Function)new Function<String, Consumer>(){

            public Consumer apply(String service) {
                return PluginSettingsConsumerServiceStore.this.get(service).getConsumer();
            }
        });
    }

    public void put(String service, ConsumerServiceStore.ConsumerAndSecret cas) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        Preconditions.checkNotNull((Object)cas, (Object)"cas");
        this.settings().putConsumerProperties(service, new ConsumerProperties(cas));
    }

    public void removeByKey(String consumerKey) {
        Preconditions.checkNotNull((Object)consumerKey, (Object)"consumerKey");
        String service = this.settings().getServiceNameForConsumerKey(consumerKey);
        if (service == null) {
            return;
        }
        this.settings().removeConsumerProperties(service, consumerKey);
    }

    private Settings settings() {
        return new Settings(this.pluginSettingsFactory.createGlobalSettings());
    }

    static final class Settings {
        private final PluginSettings settings;

        public Settings(PluginSettings settings) {
            this.settings = new PrefixingPluginSettings((PluginSettings)new HashingLongPropertyKeysPluginSettings(settings), ConsumerService.class.getName());
        }

        public ConsumerProperties getConsumerProperties(String service) {
            Properties props = (Properties)this.settings.get(service);
            if (props == null) {
                return null;
            }
            return new ConsumerProperties(props);
        }

        private void putConsumerProperties(String service, ConsumerProperties props) {
            this.settings.put(service, (Object)props.asProperties());
            this.addService(service);
            this.putServiceNameForConsumerKey(props.getConsumerKey(), service);
        }

        private void removeConsumerProperties(String service, String consumerKey) {
            this.settings.remove(service);
            this.removeService(service);
            this.removeServiceNameForConsumerKey(consumerKey);
        }

        public String getServiceNameForConsumerKey(String consumerKey) {
            return (String)this.settings.get("consumerService." + consumerKey);
        }

        private void putServiceNameForConsumerKey(String consumerKey, String service) {
            this.settings.put("consumerService." + consumerKey, (Object)service);
        }

        private void removeServiceNameForConsumerKey(String consumerKey) {
            this.settings.remove("consumerService." + consumerKey);
        }

        public Set<String> getServiceNames() {
            String encodedKeys = (String)this.settings.get("serviceNames");
            if (StringUtils.isBlank((String)encodedKeys)) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(encodedKeys.split("/")), (Function)Functions.toDecodedKeys()));
        }

        private void putServiceNames(Iterable<String> keys) {
            this.settings.put("serviceNames", (Object)Joiner.on((String)"/").join(Iterables.transform(keys, (Function)Functions.toEncodedKeys())));
        }

        private void addService(String service) {
            this.putServiceNames((Iterable<String>)Sets.union((Set)ImmutableSet.of((Object)service), this.getServiceNames()));
        }

        private void removeService(String service) {
            this.putServiceNames(Sets.filter(this.getServiceNames(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)service))));
        }

        static final class Keys {
            static final String SERVICE_NAMES = "serviceNames";
            static final String CONSUMER_SERVICE = "consumerService";

            Keys() {
            }
        }
    }
}

