define('atlassian-nps-plugin/js/nps/submission', [
    'atlassian-nps-plugin/js/nps/util'
],
/**
 * Manages the different analytics events fired by NPS. Events should be triggered
 * using this API rather than directly. All events used are tracked here.
 * @param Util used to trigger analytics events
 */
function (
    Util
) {
    "use strict";

    var Submission = {};

    // notification related events

    Submission.showNotification = function (eventAttrs) {
        Util.sendAnalyticsEvent("notification.show", eventAttrs);
    };

    // survey related events

    Submission.startSurvey = function () {
        Util.sendAnalyticsEvent("survey.start", {});
    };

    Submission.cancelSurvey = function (context) {
        var eventAttrs = {};
        if (context) {
            eventAttrs.cancelContext = context;
        }
        Util.sendAnalyticsEvent("survey.cancel", eventAttrs);
    };

    Submission.ignoreSurvey = function () {
        Util.sendAnalyticsEvent("survey.ignore", {});
    };

    Submission.submitSurvey = function (eventAttrs) {
        Util.sendAnalyticsEvent("survey.submit", eventAttrs);
    };

    // scheduling related events

    Submission.scheduleNextSurveyDate = function (eventAttrs) {
        Util.sendAnalyticsEvent("survey.schedule", eventAttrs);
    };

    // server specific events

    Submission.showAcknowledgementFlag = function (eventAttrs) {
        Util.sendAnalyticsEvent("server.acknowledge.show", eventAttrs);
    };

    Submission.acceptAcknowledgementFlag = function (eventAttrs) {
        Util.sendAnalyticsEvent("server.acknowledge.accept", eventAttrs);
    };

    Submission.closeAcknowledgementFlag = function (eventAttrs) {
        Util.sendAnalyticsEvent("server.acknowledge.close", eventAttrs);
    };

    Submission.updateNpsStatus = function (eventAttrs) {
        Util.sendAnalyticsEvent("server.status.changed", eventAttrs);
    };

    return Submission;
});
