require([
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/atlassian-nps-plugin',
    'atlassian-nps-plugin/js/nps/config-manager-server',
    'atlassian-nps-plugin/js/nps/product'
],
/**
 * This is the entry point for the NPS plugin. We persist NPS settings on the server.
 *
 * In the future, we will have the infrastructure to store per user settings
 * for all applications on the server. At that point, a new config-manager-alacarte
 * can be written and injected here. A micro-service to store the NPS data is also an
 * option.
 *
 * @param AJS
 * @param NPS main module for the NPS plugin
 * @param ServerSettingsManager server-side storage mechanism
 */
function(
    AJS,
    NPS,
    ServerSettingsManager,
    Product
) {
    "use strict";

    // Abort the NPS survey if the user is anonymous
    if (Product.getUserKey()) {
        AJS.toInit(function() {
            NPS.init(ServerSettingsManager);
        });
    }
});
