/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model.migration;

import com.atlassian.applinks.internal.common.capabilities.RemoteApplicationCapabilities;
import com.atlassian.applinks.internal.migration.AuthenticationStatus;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.migration.RestAuthenticationConfig;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RestAuthenticationStatus
extends BaseRestEntity {
    @VisibleForTesting
    public static final String OUTGOING = "outgoing";
    @VisibleForTesting
    public static final String INCOMING = "incoming";
    @VisibleForTesting
    public static final String CAPABILITIES = "capabilities";

    public RestAuthenticationStatus(@Nonnull AuthenticationStatus authenticationStatus, @Nonnull RemoteApplicationCapabilities remoteCapabilities) {
        Objects.requireNonNull(authenticationStatus, "authenticationConfigs");
        Objects.requireNonNull(remoteCapabilities, "remoteCapabilities");
        this.put(OUTGOING, (Object)new RestAuthenticationConfig(authenticationStatus.outgoing()));
        this.put(INCOMING, (Object)new RestAuthenticationConfig(authenticationStatus.incoming()));
        this.put(CAPABILITIES, (Object)remoteCapabilities.getCapabilities());
    }
}

