/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.analytics;

import com.atlassian.applinks.analytics.ApplinksStatusEvent;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.CorsAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.core.auth.AuthenticatorAccessor;
import com.atlassian.applinks.internal.event.StatusLoadedEvent;
import com.atlassian.applinks.internal.status.ApplinkStatus;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

public class StatusAnalyticsPublisher {
    private final EventPublisher eventPublisher;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final AuthenticatorAccessor authenticatorAccessor;

    @Autowired
    public StatusAnalyticsPublisher(EventPublisher eventPublisher, AuthenticationConfigurationManager manager, AuthenticatorAccessor authenticatorAccessor) {
        this.eventPublisher = eventPublisher;
        this.authenticationConfigurationManager = manager;
        this.authenticatorAccessor = authenticatorAccessor;
    }

    @PostConstruct
    public void postInit() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onStatusLoadedEvent(@Nonnull StatusLoadedEvent event) {
        ApplinkStatus status = (ApplinkStatus)Preconditions.checkNotNull((Object)((StatusLoadedEvent)Preconditions.checkNotNull((Object)event, (Object)"event")).getStatus(), (Object)"status");
        ApplinksStatusEvent.Builder builder = new ApplinksStatusEvent.Builder(event.getStatus());
        this.findConfiguredProviderTypes(status.getLink().getId(), builder);
        this.eventPublisher.publish((Object)builder.build());
    }

    private void findConfiguredProviderTypes(ApplicationId id, ApplinksStatusEvent.Builder builder) {
        for (AuthenticationProviderPluginModule module : this.authenticatorAccessor.getAllAuthenticationProviderPluginModules()) {
            Class providerClass = module.getAuthenticationProviderClass();
            if (!this.authenticationConfigurationManager.isConfigured(id, providerClass)) continue;
            if (BasicAuthenticationProvider.class.isAssignableFrom(providerClass)) {
                builder.basic = true;
                continue;
            }
            if (TrustedAppsAuthenticationProvider.class.isAssignableFrom(providerClass)) {
                builder.trusted = true;
                continue;
            }
            if (TwoLeggedOAuthAuthenticationProvider.class.isAssignableFrom(providerClass)) {
                builder.twoLo = true;
                continue;
            }
            if (TwoLeggedOAuthWithImpersonationAuthenticationProvider.class.isAssignableFrom(providerClass)) {
                builder.twoLoi = true;
                continue;
            }
            if (OAuthAuthenticationProvider.class.isAssignableFrom(providerClass)) {
                builder.threeLo = true;
                continue;
            }
            if (CorsAuthenticationProvider.class.isAssignableFrom(providerClass)) {
                builder.cors = true;
                continue;
            }
            builder.other = true;
        }
    }
}

