/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.confluence;

import com.atlassian.activeobjects.confluence.hibernate.DialectExtractor;
import com.atlassian.activeobjects.spi.AbstractTenantAwareDataSourceProvider;
import com.atlassian.activeobjects.spi.ConnectionHandler;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.dialect.DB2Dialect;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.HSQLDialect;
import net.sf.hibernate.dialect.MySQLDialect;
import net.sf.hibernate.dialect.Oracle9Dialect;
import net.sf.hibernate.dialect.PostgreSQLDialect;
import net.sf.hibernate.dialect.SQLServerDialect;

public final class ConfluenceTenantAwareDataSourceProvider
extends AbstractTenantAwareDataSourceProvider {
    private static final Map<Class<? extends Dialect>, DatabaseType> DIALECT_TO_DATABASE_MAPPING = ImmutableMap.builder().put(HSQLDialect.class, (Object)DatabaseType.HSQL).put(MySQLDialect.class, (Object)DatabaseType.MYSQL).put(PostgreSQLDialect.class, (Object)DatabaseType.POSTGRESQL).put(Oracle9Dialect.class, (Object)DatabaseType.ORACLE).put(SQLServerDialect.class, (Object)DatabaseType.MS_SQL).put(DB2Dialect.class, (Object)DatabaseType.DB2).build();
    private final SessionFactoryDataSource dataSource;
    private final DialectExtractor dialectExtractor;

    public ConfluenceTenantAwareDataSourceProvider(PluginHibernateSessionFactory sessionFactory, DialectExtractor dialectExtractor) {
        this.dataSource = new SessionFactoryDataSource((PluginHibernateSessionFactory)Preconditions.checkNotNull((Object)sessionFactory));
        this.dialectExtractor = (DialectExtractor)Preconditions.checkNotNull((Object)dialectExtractor);
    }

    @Override
    @Nonnull
    public DataSource getDataSource(@Nonnull Tenant tenant) {
        return this.dataSource;
    }

    @Override
    @Nonnull
    public DatabaseType getDatabaseType(@Nonnull Tenant tenant) {
        Class<? extends Dialect> dialect = this.dialectExtractor.getDialect();
        if (dialect == null) {
            return DatabaseType.UNKNOWN;
        }
        for (Map.Entry<Class<? extends Dialect>, DatabaseType> entry : DIALECT_TO_DATABASE_MAPPING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(dialect)) continue;
            return entry.getValue();
        }
        return super.getDatabaseType(tenant);
    }

    private static abstract class AbstractDataSource
    implements DataSource {
        private AbstractDataSource() {
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setLoginTimeout(int timeout) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public PrintWriter getLogWriter() {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public void setLogWriter(PrintWriter pw) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }
    }

    private static class SessionFactoryDataSource
    extends AbstractDataSource {
        private final PluginHibernateSessionFactory sessionFactory;

        public SessionFactoryDataSource(PluginHibernateSessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Session session = this.sessionFactory.getSession();
            try {
                return ConnectionHandler.newInstance(session.connection());
            }
            catch (HibernateException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new IllegalStateException("Not allowed to get a connection for non default username/password");
        }

        @Override
        public <T> T unwrap(Class<T> tClass) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> aClass) throws SQLException {
            return false;
        }
    }
}

