/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.miniorange.sso.saml.PluginHandler;
import com.miniorange.sso.saml.SAMLUtils;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationAction.class);
    private String idpEntityId;
    private String ssoUrl;
    private String x509Certificate;
    private String usernameAttribute;
    private String emailAttribute;
    private String defaultGroup;
    private Boolean disableDefaultLogin;
    private Boolean enableBackdoor;
    private String loginButtonText;
    private ArrayList existingGroups;
    private ArrayList idpGuides;
    private Boolean submitted;
    private Boolean reregister;
    private Boolean submitSupportQuery;
    private SAMLSettings settings;
    private PluginHandler pluginHandler;

    public ConfigurationAction(SAMLSettings settings, PluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void validate() {
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank(this.ssoUrl)) {
            this.addActionError(this.getText("samlsso.error.config.ssourl.empty"));
        } else {
            try {
                new URL(this.ssoUrl);
            }
            catch (MalformedURLException e) {
                this.addActionError(this.getText("samlsso.error.config.ssourl.malformed"));
            }
        }
        if (StringUtils.isBlank(this.idpEntityId)) {
            this.addActionError(this.getText("samlsso.error.config.idpentityid.empty"));
        }
        if (StringUtils.isBlank(this.x509Certificate)) {
            this.addActionError(this.getText("samlsso.error.config.certificate.empty"));
        } else if (!SAMLUtils.isValidCertificate(this.x509Certificate).booleanValue()) {
            this.addActionError(this.getText("samlsso.error.config.certificate.invalid"));
        }
        super.validate();
    }

    public String execute() throws Exception {
        if (!this.settings.isCustomerRegistered().booleanValue() || this.reregister != null && BooleanUtils.toBoolean((Boolean)this.reregister)) {
            this.settings.removeCustomerAccount();
            return "redirect";
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            this.settings.setIdpEntityId(this.idpEntityId);
            this.settings.setSsoServiceUrl(this.ssoUrl);
            this.settings.setX509Certificate(this.x509Certificate);
            if (this.settings.getCustomerRegisteredBefore209().booleanValue()) {
                this.settings.setUsernameAttribute(this.usernameAttribute);
                this.settings.setEmailAttribute(this.emailAttribute);
            } else {
                this.settings.setUsernameAttribute("NameID");
                this.settings.setEmailAttribute("NameID");
            }
            this.x509Certificate = SAMLUtils.serializePublicCertificate(this.x509Certificate);
            this.settings.setDefaultLoginDisabled(this.disableDefaultLogin);
            this.settings.setBackdoorEnabled(this.enableBackdoor);
            this.settings.setDefaultGroup(this.defaultGroup);
            this.settings.setLoginButtonText(this.loginButtonText);
            this.addActionMessage(this.getText("samlsso.success.config"));
        } else if (BooleanUtils.toBoolean((Boolean)this.submitSupportQuery)) {
            String email = this.getCurrentRequest().getParameter("email");
            String phone = this.getCurrentRequest().getParameter("phone");
            String query = this.getCurrentRequest().getParameter("query");
            System.out.println("query submitted" + email + phone + query);
            this.pluginHandler.submitSupportQuery(email, phone, query);
            this.addActionMessage(this.getText("samlsso.success.submit.query"));
        } else {
            this.initializeSAMLConfig();
        }
        return "success";
    }

    public void initializeSAMLConfig() {
        this.idpEntityId = this.settings.getIdpEntityId();
        this.ssoUrl = this.settings.getSsoServiceUrl();
        this.x509Certificate = this.settings.getX509Certificate();
        if (this.settings.getCustomerRegisteredBefore209().booleanValue()) {
            this.usernameAttribute = this.settings.getUsernameAttribute();
            this.emailAttribute = this.settings.getEmailAttribute();
        } else {
            this.usernameAttribute = "NameID";
            this.emailAttribute = "NameID";
        }
        this.disableDefaultLogin = this.settings.getDefaultLoginDisabled();
        this.enableBackdoor = this.settings.getBackdoorEnabled();
        this.defaultGroup = this.settings.getDefaultGroup();
        this.loginButtonText = this.settings.getLoginButtonText();
    }

    public ArrayList<String> getExistingGroups() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List groupObjects = userAccessor.getGroupsAsList();
        this.existingGroups = new ArrayList();
        for (Group groupObject : groupObjects) {
            this.existingGroups.add(groupObject.getName());
        }
        return this.existingGroups;
    }

    public SAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    public String getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(String x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getDisableDefaultLogin() {
        return this.disableDefaultLogin;
    }

    public void setDisableDefaultLogin(Boolean disableDefaultLogin) {
        this.disableDefaultLogin = disableDefaultLogin;
    }

    public Boolean getEnableBackdoor() {
        return this.enableBackdoor;
    }

    public void setEnableBackdoor(Boolean enableBackdoor) {
        this.enableBackdoor = enableBackdoor;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public String getLoginButtonText() {
        return this.loginButtonText;
    }

    public void setLoginButtonText(String loginButtonText) {
        this.loginButtonText = loginButtonText;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getSubmitSupportQuery() {
        return this.submitSupportQuery;
    }

    public void setSubmitSupportQuery(Boolean submitSupportQuery) {
        this.submitSupportQuery = submitSupportQuery;
    }

    public ArrayList<String> getIdpGuides() {
        ArrayList<String> idp = new ArrayList<String>();
        idp.add("ADFS");
        idp.add("G Suite");
        idp.add("Centrify");
        idp.add("Okta");
        idp.add("OneLogin");
        idp.add("Salesforce");
        idp.add("JBoss Keycloak");
        idp.add("Oracle");
        idp.add("Bitium");
        idp.add("PingFederate");
        idp.add("Shibboleth2");
        idp.add("Shibboleth3");
        idp.add("WSO2");
        idp.add("OpenAM");
        Collections.sort(idp);
        this.idpGuides = idp;
        return this.idpGuides;
    }

    public void setIdpGuides(ArrayList idpGuides) {
        this.idpGuides = idpGuides;
    }
}

