/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml;

import com.miniorange.sso.saml.SAMLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLUtils {
    public static final String AUTHN_REQUEST_PARAM = "SAMLRequest";
    public static final String RELAY_STATE_PARAM = "RelayState";
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";

    public static AuthnRequest buildAuthnRequest(String issuer, String acsUrl, String destination) {
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
        DateTime issueInstant = new DateTime();
        authnRequest.setID(SAMLUtils.generateRandomString());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(issueInstant);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setIssuer(SAMLUtils.buildIssuer(issuer));
        authnRequest.setAssertionConsumerServiceURL(acsUrl);
        authnRequest.setDestination(destination);
        return authnRequest;
    }

    private static Issuer buildIssuer(String issuerValue) {
        Issuer issuer = new IssuerBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml");
        issuer.setValue(issuerValue);
        return issuer;
    }

    public static String base64EncodeRequest(SignableXMLObject request) throws Exception {
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(request);
        Element authDOM = marshaller.marshall(request);
        StringWriter requestWriter = new StringWriter();
        XMLHelper.writeNode((Node)authDOM, requestWriter);
        String requestMessage = requestWriter.toString();
        Deflater deflater = new Deflater(-1, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(requestMessage.getBytes());
        deflaterOutputStream.close();
        byteArrayOutputStream.close();
        String encodedRequestMessage = org.opensaml.xml.util.Base64.encodeBytes(byteArrayOutputStream.toByteArray(), 8);
        return encodedRequestMessage;
    }

    public static Response decodeResponse(String encodedResponse) throws Exception {
        String xml = new String(org.opensaml.xml.util.Base64.decode(encodedResponse), "UTF-8");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        Document document = docBuilder.parse(is);
        Element element = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        XMLObject xmlObj = unmarshaller.unmarshall(element);
        Response response = (Response)xmlObj;
        return response;
    }

    public static Boolean verifyCertificate(SignableXMLObject response, String certificate) throws CertificateException, ValidationException {
        if (response.isSigned()) {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(response.getSignature());
            Credential verificationCredential = SAMLUtils.getCredential(certificate);
            SignatureValidator sigValidator = new SignatureValidator(verificationCredential);
            sigValidator.validate(response.getSignature());
            return Boolean.TRUE;
        }
        if (response instanceof Response) {
            throw new SAMLException(SAMLException.SAMLErrorCode.RESPONSE_NOT_SIGNED);
        }
        throw new SAMLException(SAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
    }

    private static Credential getCredential(String certificate) throws CertificateException {
        certificate = SAMLUtils.serializePublicCertificate(certificate);
        ByteArrayInputStream is = new ByteArrayInputStream(certificate.getBytes());
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        BasicX509Credential x509Credential = new BasicX509Credential();
        x509Credential.setPublicKey(cert.getPublicKey());
        BasicX509Credential credential = x509Credential;
        return credential;
    }

    public static String serializePublicCertificate(String certificate) {
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64(certificate));
            StringBuffer cert = new StringBuffer("-----" + BEGIN_CERTIFICATE + "-----\r\n");
            cert.append(certificate);
            cert.append("-----" + END_CERTIFICATE + "-----");
            return cert.toString();
        }
        return certificate;
    }

    public static String deserializePublicCertificate(String certificate) {
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    public static Boolean isValidCertificate(String certificate) {
        certificate = SAMLUtils.serializePublicCertificate(certificate);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
            return Boolean.TRUE;
        }
        catch (CertificateException e) {
            return Boolean.FALSE;
        }
    }

    public static String generateRandomString() {
        String uuid = UUID.randomUUID().toString();
        return "_" + StringUtils.remove((String)uuid, (char)'-');
    }
}

