
function fillFields() {
  cleanupConfig();
  removeAllIdpFields();
  createIdpFields();
  fillFieldData(configurationObject,'');  
  
  // Trigger the change handler for elements with the afterfill_change-class
  AJS.$('.afterfill_change').trigger('change');
}

function fillFieldData(dataObject, prefix) {
  AJS.$.each( dataObject, function( key,valueObject ){
    var type = AJS.$.type(valueObject);
    if(type == 'array') {
      //console.log("Calling me recusively for " + key);
      AJS.$.each( valueObject, function( index, childValueObject) {
        // The fieldId is the JSON-attribute name for flat values.
        // If it's an array, the id is prefixed with the parent's 
        // attribute name and the array index position, separated with _
        fillFieldData(childValueObject, key + '_' + index + '_');
      });    
    } else {
      var fieldId = prefix + key
      var field = AJS.$('#' + fieldId);
      if(field.length > 0 ) {
        fieldValue = dataObject[key];
        if(field.hasClass('newlineseparated')) {
          log.debug('Replacing commas with newlines on field ' + fieldId);
          fieldValue = replaceCommasWithNewlines( fieldValue )
        }
        log.debug('Filling ' + fieldId + ' with ' + fieldValue);
        if(field.attr('type') == 'checkbox' || field.attr('type') == 'radio') {
          AJS.$(field).prop('checked',fieldValue);
        } else {
          AJS.$(field).val(fieldValue);
        }  
      } else {
        log.debug('Found no field ' + fieldId);
      }
    }   
  }); 
}

function readFields() {
  cleanupConfig();
  readFieldData(configurationObject,'');  
}

function readFieldData(dataObject, prefix) {
  AJS.$.each( dataObject, function( key,valueObject ){
    var type = AJS.$.type(valueObject);
    if(type == 'array') {
      //console.log("Calling me recusively for " + key);
      AJS.$.each( valueObject, function( index, childValueObject) {
        // The fieldId is the JSON-attribute name for flat values.
        // If it's an array, the id is prefixed with the parent's 
        // attribute name and the array index position, separated with _
        readFieldData(childValueObject, key + '_' + index + '_');
      });    
    } else {
      var fieldId = prefix + key
      var field = AJS.$('#' + fieldId);
      if(field.length > 0 ) {
        if(field.attr('type') == 'checkbox' || field.attr('type') == 'radio') {
          fieldValue = AJS.$(field).prop('checked');
        } else {
          fieldValue = AJS.$(field).val();
          if(field.hasClass('newlineseparated')) {
            log.debug('Replacing newlines with commas on field ' + fieldId);
            fieldValue = replaceNewlinesWithCommas( fieldValue );
          }
        }
        log.debug('Updating ' + fieldId + ' to ' + fieldValue);
        dataObject[key] = fieldValue;
      } else {
        log.debug('Found no field ' + fieldId);
      }
    }   
  }); 
}