
/*
 * Removes all IdP fields
 */
function removeAllIdpFields() {
  AJS.$('#idpConfigurationDiv').empty();
}

/*
 * Iterates the idpConfigurations from the configrationObject and
 * creates the form fields for each IdP
 * The created fields are filled in the general fillFields-function
 */
function createIdpFields() {
  var parentElement =  AJS.$('#idpConfigurationDiv');
  AJS.$.each( configurationObject.idpConfigurations, function (index, idpConfig) {
    addIdpFields( parentElement, index, idpConfig );
  });
}

/*
 * Removes a single IdP-form-block and sets the idp-array-element to null
 * This function is bound to the delete-IdP-buttons
 */
function removeIdp(index, idpContainer) {
  log.debug("Removing IdP " + index);
  // Setting the appropriate array-element to null so it will be removed during next cleanup.
  configurationObject.idpConfigurations[index] = null;
  idpContainer.remove();
}

/*
 * Creates a new IdP-configuration-element with default values and adds the 
 * the appropriate fields.
 * This function is bound to the add-IdP-button
 */
function addIdP() {
  var parentElement =  AJS.$('#idpConfigurationDiv');
  
  //Create a new idpConfiguration from the defaults and add it to the global configuration object
  var newIdpConfig =  AJS.$.extend(true,{},configurationObject.defaultIdpConfiguration);
  configurationObject.idpConfigurations.push(newIdpConfig);
  
  var index = configurationObject.idpConfigurations.length - 1;
  addIdpFields( parentElement, index, newIdpConfig );
 
  // Fill the newly created fields with the default-data from the new idp configuration object
  var prefix = 'idpConfigurations_' + index + '_';
  fillFieldData(newIdpConfig, prefix); // Fill the newly-created field
  AJS.$('#idpConfigurations_' + index + '_useMetadataxml').trigger('change');  
}

/*
 * Appends a new IDP-fields-block to the parent-element using the given index
 */
function addIdpFields( parentElement, index, idpConfiguration ) {
  //Call the soy-created template and append it to the container element
  var idpContainer = AJS.$(Resolution.SAMLSSO.idpsettings({index: index,jira6: jira6,servicedesk: servicedesk,confluence: confluence}));
  parentElement.append(idpContainer);
 
  // Enable the delete-button
  AJS.$('#idpConfigurations_' + index + '_deletebutton').click( function(e) { 
    removeIdp(index,idpContainer);
  });
  
  // Enable the certificate-check
  AJS.$('#idpConfigurations_' + index + '_certificate').on( "change paste", function(e) { 
    checkCertificate(
      AJS.$('#idpConfigurations_' + index + '_certificate' ), 
      AJS.$('#idpConfigurations_' + index + '_certstatus'  ), 
      AJS.$('#idpConfigurations_' + index + '_decoded-cert') 
    )
  });
  
//Enable the certificate-check
  AJS.$('#idpConfigurations_' + index + '_secondCertificate').on( "change paste", function(e) { 
    checkCertificate(
      AJS.$('#idpConfigurations_' + index + '_secondCertificate' ), 
      AJS.$('#idpConfigurations_' + index + '_secondCertstatus'  ), 
      AJS.$('#idpConfigurations_' + index + '_secondDecoded-cert') 
    )
  });
  
  // Add the directory-Options
  setSelectOptions(AJS.$('#idpConfigurations_' + index + '_directoryIdForNewUsers'),configurationObject.directoryList,false);
  
  // Enable the dropdowns for the IdP-attributes
  var attributeMap = idpConfiguration.idpAttributes;
  enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_useridAttribute'),   AJS.$('#idpConfigurations_' + index + '_selector-useridAttribute'),   attributeMap, index);
  enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_fullnameAttribute'), AJS.$('#idpConfigurations_' + index + '_selector-fullnameAttribute'), attributeMap, index);
  enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_emailAttribute'),    AJS.$('#idpConfigurations_' + index + '_selector-emailAttribute'),    attributeMap, index);
  enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_groupAttribute'),    AJS.$('#idpConfigurations_' + index + '_selector-groupAttribute'),    attributeMap, index);
  
  AJS.$('#idpConfigurations_' + index + '_radioButtonMetadataFromURL').unbind('change');
  AJS.$('#idpConfigurations_' + index + '_radioButtonMetadataFromURL').change(function(e) {
    setMetadataFieldType(index);
  });
  AJS.$('#idpConfigurations_' + index + '_useMetadataxml').unbind('change');
  AJS.$('#idpConfigurations_' + index + '_useMetadataxml').change(function(e) {
    setMetadataFieldType(index);
  });
 
  AJS.$('#idpConfigurations_' + index + '_metadata-loadbutton').unbind('click');
  AJS.$('#idpConfigurations_' + index + '_metadata-loadbutton').click( function(e) {  
    readMetadata(index);
  });
}

/*
 * Shows the URL or XML inputs
 */
function setMetadataFieldType(index) {
  log.debug('SetMetadataContent for index ' + index);
  if(AJS.$('#idpConfigurations_' + index + '_radioButtonMetadataFromURL').prop('checked')) {
    log.debug('showing url');
    AJS.$('#idpConfigurations_' + index + '_metadata_xml_fields').hide();
    AJS.$('#idpConfigurations_' + index + '_metadata_url_fields').show();
  } else if(AJS.$('#idpConfigurations_' + index + '_useMetadataxml').prop('checked')) {
    log.debug('showing xml');
    AJS.$('#idpConfigurations_' + index + '_metadata_url_fields').hide();
    AJS.$('#idpConfigurations_' + index + '_metadata_xml_fields').show();
  }
}

/*
 * Reads the metadata from the URL or XML, sends it to the backend for parsing and fills the form fields
 * with data from the result map
 */
function readMetadata(index) {  
  var url =        AJS.$('#idpConfigurations_' + index + '_metadataurl').val();
  var xml =        AJS.$('#idpConfigurations_' + index + '_metadataxml').val();
  var ignorecert = AJS.$('#idpConfigurations_' + index + '_metadataignorecert' ).prop('checked');
  var useXML =     AJS.$('#idpConfigurations_' + index + '_useMetadataxml').prop('checked')
  log.debug( AJS.$('#idpConfigurations_' + index + '_useMetadataxml').prop('checked'))
  log.debug('Fetching Metadata ' + useXML); 
  
  configurationObject.idpConfigurations[index].metadataurl = url;
  configurationObject.idpConfigurations[index].metadataignorecert = ignorecert;

  var fetchingInfo = { 'metadataXML':xml,
    'metadataURL':url,
    'ignoreCertificate':ignorecert,
    'useMetadataxml' : useXML
  };

  if((url != undefined && url != "" && url.substr(0,4) == "http") || (xml != undefined && xml != "")) {
    
    AJS.$('#idpConfigurations_' + index + '_metadata-loadbutton').spin();
    AJS.$('#idpConfigurations_' + index + '_metadataerror').empty();
    AJS.$('#idpConfigurations_' + index + '_metadataerror').hide();

    AJS.$.ajax({
      url: baseUrl + '/rest/samlsso-admin/1.0/readMetadata',
      type: 'POST',
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(fetchingInfo),
      processData: true,
      success: function (result) { 
        AJS.$('#idpConfigurations_' + index + '_issuer').val(result.entityId);
        AJS.$('#idpConfigurations_' + index + '_url').val(result.ssoPOSTUrl);
        AJS.$('#idpConfigurations_' + index + '_certificate').val('---BEGIN CERTIFICATE---\n' + result.signingCertificate);
        AJS.$('#idpConfigurations_' + index + '_certificate').trigger('change');
        AJS.$('#idpConfigurations_' + index + '_metadata-loadbutton').spinStop();

        configurationObject.idpConfigurations[index].idpAttributes = result.attributes;
        
        // Update the IdP-attribute-dropdowns
        var attributeMap = result.attributes;
        enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_useridAttribute'),   AJS.$('#idpConfigurations_' + index + '_selector-useridAttribute'),   attributeMap, index);
        enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_fullnameAttribute'), AJS.$('#idpConfigurations_' + index + '_selector-fullnameAttribute'), attributeMap, index);
        enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_emailAttribute'),    AJS.$('#idpConfigurations_' + index + '_selector-emailAttribute'),    attributeMap, index);
        enableSelectOptions(AJS.$('#idpConfigurations_' + index + '_groupAttribute'),    AJS.$('#idpConfigurations_' + index + '_selector-groupAttribute'),    attributeMap, index);
        
        // Add the options to the userid-dropdown
        AJS.$('#idpConfigurations_' + index + '_metadataerror').empty();
        AJS.$('#idpConfigurations_' + index + '_metadataerror').hide();   
      },
      error: function(result) { 
        AJS.$('#idpConfigurations_' + index + '_metadataerror').append("<p>" + result.responseText + "</p>");
        AJS.$('#idpConfigurations_' + index + '_metadataerror').show();
        AJS.$('#idpConfigurations_' + index + '_metadata-loadbutton').spinStop();
      }
    }); 
  } 
}

/*
 * Synchronizes a text field's content with a dropdown 
 */
function enableSelectOptions(textField, selectField, attributeMap, index) {
  setSelectOptions(selectField,attributeMap,true);
  selectField.unbind('change');
  selectField.change(function() {
    textField.val(selectField.val());
  });
  
  textField.unbind('change');
  textField.change(function() {
    selectField.val(textField.val());
    if(selectField.val() == '') {
      selectField.val('other');
    }
  });
}