
AJS.toInit( function() {
	// Hide these items
	AJS.$('#notFound').hide();
	AJS.$('#redirecting').hide();	

	// The form is never submitted
	AJS.$("#emailAddressForm").submit(function(e) {
		e.preventDefault();
	});

	AJS.$("#emailAddressField").on('input',function(e) {
		checkEmailField();
	});
}); 

function checkEmailField() {
	// The input must have an @ and a . behind it to be ready to be checked
	addressPattern = new RegExp(".*@.*\\...+");
	enteredEmail = AJS.$("#emailAddressField").val();	
	if(addressPattern.test(enteredEmail)) {
		atPosition = enteredEmail.indexOf('@');
		if(atPosition >= 0) {
			emailDomain = enteredEmail.substring(atPosition + 1).toLowerCase();
			if(emailDomain) {
				shaObject = new jsSHA("SHA-256", "TEXT");
				shaObject.update(emailDomain);
				emailDomain_sha224 = shaObject.getHash("HEX");

				var idpId = 0;
				for (var key in emailDomains) {
					if(key == emailDomain_sha224) {
						idpId = emailDomains[key];
					}
				}
				if(idpId != 0) {
					AJS.$('#notFound').hide();
					AJS.$('#redirecting').show();
					AJS.$('#emailAddressField').prop('disabled', true);

					redirectUrl = ssoURL.replace('IDPID',idpId);
					// This avoids a warning message when starting the redirect
					window.onbeforeunload = function() {};
					window.location = redirectUrl;
				} else {
					AJS.$('#notFound').show();
				}	
			} 
		} 
	} else {
		AJS.$('#notFound').hide();
		AJS.$('#redirecting').hide();	
	}
}

