/*
 * Checks the BASE64-encoded certificate by sending the data to the backend
 */
function checkCertificate(certField, lozenge, readableDiv) {
  var certString = certField.val().trim();

  if(certString == "") {
    AJS.$(lozenge).removeClass();
    AJS.$(lozenge).addClass("aui-lozenge aui-lozenge-current");
    AJS.$(lozenge).text("not set");
    AJS.$(readableDiv).text("No certificate set");
  } else {
    var spinner = AJS.$("<span>",{"class":"aui-icon aui-icon-wait"});
    AJS.$(lozenge).removeClass();
    AJS.$(lozenge).addClass("aui-lozenge");
    AJS.$(lozenge).text("checking ");
    AJS.$(lozenge).append(spinner);

    AJS.$.ajax({
      url: baseUrl + "/rest/samlsso-admin/1.0/checkCertificate",
      type: "PUT",
      contentType: "text/plain; charset=utf-8",
      data: certString,
      success: function(result) { 
        AJS.$(lozenge).empty();
        AJS.$(lozenge).removeClass();
        AJS.$(lozenge).addClass("aui-lozenge aui-lozenge-success");
        AJS.$(lozenge).text("OK");
        AJS.$(readableDiv).html(escapeHtmlAndNewlines(result));
      },
      error: function(result) { 
        AJS.$(lozenge).empty();
        AJS.$(lozenge).removeClass();
        AJS.$(lozenge).addClass("aui-lozenge aui-lozenge-error");
        AJS.$(lozenge).text("Validity check failed");
        AJS.$(readableDiv).text(result.responseText);
      },
      statusCode: {
        400: function(result) {
          AJS.$(lozenge).empty();
          AJS.$(lozenge).removeClass();
          AJS.$(lozenge).addClass("aui-lozenge aui-lozenge-error");
          AJS.$(lozenge).text("Invalid");
          AJS.$(readableDiv).text(result.responseText);  
        }
      }    
    });  
  }
}