/*
 * Javascript-Code common for all SAMLSSO-Plugins 
 */

var baseUrl;
var jira6;
var confluence;
var servicedesk;

// Holds the configuration, must be updated during reading fields
var configurationObject;

/*
 * Initializes the page
 */
AJS.toInit( function() {
  
  log.setLevel('warn');
 
  baseUrl = AJS.$("meta[name='application-base-url']").attr("content");
  jira6 = AJS.$("meta[name='jira6']").attr("content");
  if(jira6 == undefined) {
    jira6 = false;
  }
  log.debug("jira6 is " + jira6);
  
  servicedesk = AJS.$("meta[name='servicedesk']").attr("content");
  if(servicedesk == undefined) {
    servicedesk = false;
  }
  
  confluence = AJS.$("meta[name='confluence']").attr("content");
  if(confluence == undefined) {
    confluence = false;
  }
  log.debug("confluence is " + confluence);
  
  // Setting the baseUrl meta tag in confluence is not working, but there is a provided
  // meta-tag called confluence-base-url that does the job.
  if(typeof baseUrl === "undefined") {
    baseUrl = AJS.$("meta[name='confluence-base-url']").attr("content");
  }
  
  // The form is never submitted
  AJS.$("#admin").submit(function(e) {
    e.preventDefault();
  });

  AJS.$("#saveButton").click(function(e) {
    updateConfig();
  });

  AJS.$("#cancelButton").click(function(e) {
    AJS.$("#aui-message-bar").empty(); 
    loadConfig();
  });

  AJS.$("#addIdPButton").click(function(e) {
    addIdP();
  });
  
  AJS.$('.ffi input[type="file"]').fancyFileInput();
  AJS.$('#config-upload').change(function(e) { checkConfigUploadFile(e) });
   
  // The selection page and the selection by email function should not be active at the same time
  AJS.$("#enableIdPSelection").change(function(e) {
	  if( AJS.$("#enableIdPSelection").prop('checked') == true) {
		  AJS.$("#enableIdPSelectionByEmailAddress").prop('checked',false);
	  } 
  });
  AJS.$("#enableIdPSelectionByEmailAddress").change(function(e) {
	  if( AJS.$("#enableIdPSelectionByEmailAddress").prop('checked') == true) {
		  AJS.$("#enableIdPSelection").prop('checked',false);
	  }
  });
  
  
  

  // Call the application-specific initialization
  init_specific();
  
  loadConfig();
}); 

