/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Timer;
import org.apache.commons.httpclient.HttpClient;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FileBackedHTTPMetadataProvider
extends HTTPMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(FileBackedHTTPMetadataProvider.class);
    private File metadataBackupFile;

    @Deprecated
    public FileBackedHTTPMetadataProvider(String metadataURL, int requestTimeout, String backupFilePath) throws MetadataProviderException {
        super(metadataURL, requestTimeout);
        this.setBackupFile(backupFilePath);
    }

    public FileBackedHTTPMetadataProvider(Timer backgroundTaskTimer, HttpClient client, String metadataURL, String backupFilePath) throws MetadataProviderException {
        super(backgroundTaskTimer, client, metadataURL);
        this.setBackupFile(backupFilePath);
    }

    @Override
    public synchronized void destroy() {
        this.metadataBackupFile = null;
        super.destroy();
    }

    protected void setBackupFile(String backupFilePath) throws MetadataProviderException {
        File backingFile = new File(backupFilePath);
        if (!backingFile.exists()) {
            try {
                backingFile.createNewFile();
            }
            catch (IOException e) {
                this.log.error("Unable to create backing file " + backupFilePath, (Throwable)e);
                throw new MetadataProviderException("Unable to create backing file " + backupFilePath, e);
            }
        }
        if (backingFile.isDirectory()) {
            throw new MetadataProviderException("Filepath " + backupFilePath + " is a directory and may not be used as a backing metadata file");
        }
        if (!backingFile.canRead()) {
            throw new MetadataProviderException("Filepath " + backupFilePath + " exists but can not be read by this user");
        }
        if (!backingFile.canWrite()) {
            throw new MetadataProviderException("Filepath " + backupFilePath + " exists but can not be written to by this user");
        }
        this.metadataBackupFile = backingFile;
    }

    @Override
    protected byte[] fetchMetadata() throws MetadataProviderException {
        try {
            return super.fetchMetadata();
        }
        catch (MetadataProviderException e) {
            if (this.metadataBackupFile.exists()) {
                try {
                    return DatatypeHelper.fileToByteArray(this.metadataBackupFile);
                }
                catch (IOException ioe) {
                    String errMsg = "Unable to retrieve metadata from backup file " + this.metadataBackupFile.getAbsolutePath();
                    this.log.error(errMsg, (Throwable)ioe);
                    throw new MetadataProviderException(errMsg, ioe);
                }
            }
            this.log.error("Unable to read metadata from remote server and backup does not exist");
            throw new MetadataProviderException("Unable to read metadata from remote server and backup does not exist");
        }
    }

    @Override
    protected void postProcessMetadata(byte[] metadataBytes, Document metadataDom, XMLObject metadata) throws MetadataProviderException {
        try {
            FileOutputStream out = new FileOutputStream(this.metadataBackupFile);
            out.write(metadataBytes);
            out.flush();
            out.close();
            super.postProcessMetadata(metadataBytes, metadataDom, metadata);
        }
        catch (IOException e) {
            String errMsg = "Unable to write metadata to backup file " + this.metadataBackupFile.getAbsolutePath();
            this.log.error(errMsg);
            throw new MetadataProviderException(errMsg, e);
        }
    }
}

