/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1OctetString;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1OutputStream;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.commons.ssl.org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class ASN1Integer
extends ASN1Primitive {
    byte[] bytes;

    public static ASN1Integer getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Integer) {
            return (ASN1Integer)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Integer)ASN1Integer.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof ASN1Integer) {
            return ASN1Integer.getInstance(o);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(obj.getObject()).getOctets());
    }

    public ASN1Integer(long value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public ASN1Integer(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public ASN1Integer(byte[] bytes) {
        this(bytes, true);
    }

    ASN1Integer(byte[] bytes, boolean clone) {
        this.bytes = clone ? Arrays.clone(bytes) : bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.bytes.length) + this.bytes.length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(2, this.bytes);
    }

    public int hashCode() {
        int value = 0;
        for (int i = 0; i != this.bytes.length; ++i) {
            value ^= (this.bytes[i] & 0xFF) << i % 4;
        }
        return value;
    }

    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer other = (ASN1Integer)o;
        return Arrays.areEqual(this.bytes, other.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

