/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.Java13KeyManagerWrapper;
import org.apache.commons.ssl.Java13TrustManagerWrapper;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.TrustChain;

public final class Java13
extends JavaImpl {
    private static final Java13 instance = new Java13();

    private Java13() {
        try {
            Class<?> c = Class.forName("javax.crypto.Cipher");
            Class[] sig = new Class[]{String.class};
            String[] args = new String[]{"DES/CBC/PKCS5Padding"};
            Method m = c.getMethod("getInstance", sig);
            m.invoke(null, (Object[])args);
        }
        catch (Exception e) {
            try {
                Class<?> c = Class.forName("com.sun.crypto.provider.SunJCE");
                Security.addProvider((java.security.Provider)c.newInstance());
            }
            catch (Exception e2) {
                System.out.println("com.sun.crypto.provider.SunJCE unavailable: " + e2);
            }
        }
        try {
            URL u = new URL("https://vancity.com/");
            u.openConnection();
        }
        catch (Exception e) {
            Security.addProvider((java.security.Provider)new Provider());
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        }
    }

    public static Java13 getInstance() {
        return instance;
    }

    public final String getVersion() {
        return "Java13";
    }

    protected final String retrieveSubjectX500(java.security.cert.X509Certificate cert) {
        return cert.getSubjectDN().toString();
    }

    protected final String retrieveIssuerX500(java.security.cert.X509Certificate cert) {
        return cert.getIssuerDN().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Certificate[] retrievePeerCerts(SSLSession sslSession) throws SSLPeerUnverifiedException {
        X509Certificate[] chain = sslSession.getPeerCertificateChain();
        Certificate[] newChain = new java.security.cert.X509Certificate[chain.length];
        try {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate javaxCert = chain[i];
                byte[] encoded = javaxCert.getEncoded();
                ByteArrayInputStream in = new ByteArrayInputStream(encoded);
                CertificateFactory certificateFactory = Certificates.CF;
                synchronized (certificateFactory) {
                    Certificate c = Certificates.CF.generateCertificate(in);
                    newChain[i] = (java.security.cert.X509Certificate)c;
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw this.buildRuntimeException(e);
        }
        return newChain;
    }

    protected final Object buildKeyManagerFactory(KeyStore ks, char[] password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)alg);
        kmf.init(ks, password);
        return kmf;
    }

    protected final Object buildTrustManagerFactory(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        String alg = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)alg);
        tmf.init(ks);
        return tmf;
    }

    protected final Object[] retrieveKeyManagers(Object keyManagerFactory) {
        KeyManagerFactory kmf = (KeyManagerFactory)keyManagerFactory;
        return kmf.getKeyManagers();
    }

    protected final Object[] retrieveTrustManagers(Object trustManagerFactory) {
        TrustManagerFactory tmf = (TrustManagerFactory)trustManagerFactory;
        return tmf.getTrustManagers();
    }

    protected final SSLSocketFactory buildSSLSocketFactory(Object ssl) {
        return ((SSLContext)ssl).getSocketFactory();
    }

    protected final SSLServerSocketFactory buildSSLServerSocketFactory(Object ssl) {
        return ((SSLContext)ssl).getServerSocketFactory();
    }

    protected final RuntimeException buildRuntimeException(Exception cause) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(512);
        PrintStream ps = new PrintStream(byteOut);
        ps.println(cause.toString());
        cause.printStackTrace(ps);
        ps.flush();
        String originalCause = byteOut.toString();
        return new RuntimeException(originalCause);
    }

    protected final SSLSocket buildSocket(SSL ssl) {
        throw new UnsupportedOperationException();
    }

    protected final SSLSocket buildSocket(SSL ssl, String remoteHost, int remotePort, InetAddress localHost, int localPort, int connectTimeout) throws IOException {
        SSLSocketFactory sf = ssl.getSSLSocketFactory();
        SSLSocket s = (SSLSocket)this.connectSocket(null, sf, remoteHost, remotePort, localHost, localPort, -1, ssl);
        ssl.doPreConnectSocketStuff(s);
        ssl.doPostConnectSocketStuff(s, remoteHost);
        return s;
    }

    protected final Socket buildPlainSocket(SSL ssl, String remoteHost, int remotePort, InetAddress localHost, int localPort, int connectTimeout) throws IOException {
        SocketFactory sf = SocketFactory.getDefault();
        Socket s = this.connectSocket(null, sf, remoteHost, remotePort, localHost, localPort, -1, ssl);
        ssl.doPreConnectSocketStuff(s);
        ssl.doPostConnectSocketStuff(s, remoteHost);
        return s;
    }

    protected final Socket connectSocket(Socket s, SocketFactory sf, String remoteHost, int remotePort, InetAddress localHost, int localPort, int timeout, SSL ssl) throws IOException {
        remoteHost = ssl.dnsOverride(remoteHost);
        if (s == null) {
            s = sf == null ? new Socket(remoteHost, remotePort, localHost, localPort) : sf.createSocket(remoteHost, remotePort, localHost, localPort);
        }
        return s;
    }

    protected final SSLServerSocket buildServerSocket(SSL ssl) {
        throw new UnsupportedOperationException();
    }

    protected final void wantClientAuth(Object o, boolean wantClientAuth) {
    }

    protected final void enabledProtocols(Object o, String[] enabledProtocols) {
    }

    protected void checkTrusted(Object trustManager, java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = (X509TrustManager)trustManager;
        boolean result = tm.isServerTrusted(chain);
        if (!result) {
            throw new CertificateException("commons-ssl java13 mode: certificate chain not trusted");
        }
    }

    protected final Object initSSL(SSL ssl, TrustChain tc, KeyMaterial k) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException, IOException {
        int i;
        SSLContext context = SSLContext.getInstance((String)ssl.getDefaultProtocol());
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        if (tc != null) {
            trustManagers = (TrustManager[])tc.getTrustManagers();
        }
        if (k != null) {
            keyManagers = (KeyManager[])k.getKeyManagers();
        }
        if (keyManagers != null) {
            for (i = 0; i < keyManagers.length; ++i) {
                if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                X509KeyManager km = (X509KeyManager)keyManagers[i];
                keyManagers[i] = new Java13KeyManagerWrapper(km, k, ssl);
            }
        }
        if (trustManagers != null) {
            for (i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                X509TrustManager tm = (X509TrustManager)trustManagers[i];
                trustManagers[i] = new Java13TrustManagerWrapper(tm, tc, ssl);
            }
        }
        context.init(keyManagers, trustManagers, null);
        return context;
    }
}

