/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.samlprocessor;

import com.resolution.samlprocessor.FieldCombiner;
import com.resolution.samlprocessor.SAMLProcessor;
import com.resolution.samlprocessor.SAMLProcessorException;
import com.resolution.samlprocessor.SAMLResponseContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SingleIdpSAMLProcessor {
    private final String useridAttribute;
    private final String idpUrl;
    private final String emailAttribute;
    private final String fullNameAttribute;
    private final String groupAttribute;
    private final String issuerIdP;
    private final String consumerURL;
    private final String relayStateParameterName;
    private final SAMLSignatureProfileValidator signatureProfileValidator = new SAMLSignatureProfileValidator();
    private final SignatureValidator idpSignatureValidator;
    private final SignatureValidator secondIdpSignatureValidator;
    private final boolean omitRequestedAuthnContext;
    private final String useridTransformationRegex;
    private final String useridTransformationReplacement;
    private final boolean lowercaseConvert;
    private final boolean lowercaseConvertGroups;
    private final List<String> defaultGroups;
    private final List<String> defaultSdCustomerGroups;
    private final boolean updateUser;
    private final boolean removeFromGroups;
    private final boolean updateExisting;
    private final Long directoryForNewUsers;
    private final boolean enforceResponseValidityDates;
    private final int clockSkew;
    private final boolean skipCertificateValidation;
    private static final Logger logger = LoggerFactory.getLogger(SingleIdpSAMLProcessor.class);

    public SingleIdpSAMLProcessor(String idpUrl, String issuerIdP, String useridAttribute, String emailAttribute, String fullNameAttribute, String groupAttribute, String consumerURL, String relayStateParameterName, String base64encodedCertificate, String secondBase64encodedCertificate, boolean omitRequestedAuthnContext, String useridTransformationRegex, String useridTransformationReplacement, boolean lowercaseConvert, boolean lowercaseConvertGroups, List<String> defaultGroups, List<String> defaultSdCustomerGroups, boolean updateUser, boolean removeFromGroups, boolean updateExisting, Long directoryIdForNewUsers, boolean enforceResponseValidityDates, int clockSkew) throws CertificateException {
        PublicKey pk;
        X509Certificate idpCertificate;
        Collection<X509Certificate> certificates;
        BasicX509Credential publicCredential;
        this.idpUrl = idpUrl;
        this.issuerIdP = issuerIdP;
        this.consumerURL = consumerURL;
        this.relayStateParameterName = relayStateParameterName;
        this.omitRequestedAuthnContext = omitRequestedAuthnContext;
        this.useridTransformationRegex = useridTransformationRegex;
        this.useridTransformationReplacement = useridTransformationReplacement;
        this.lowercaseConvert = lowercaseConvert;
        this.lowercaseConvertGroups = lowercaseConvertGroups;
        this.useridAttribute = useridAttribute;
        this.fullNameAttribute = fullNameAttribute;
        this.emailAttribute = emailAttribute;
        this.groupAttribute = groupAttribute;
        this.defaultGroups = defaultGroups;
        this.defaultSdCustomerGroups = defaultSdCustomerGroups;
        this.updateUser = updateUser;
        this.removeFromGroups = removeFromGroups;
        this.updateExisting = updateExisting;
        this.directoryForNewUsers = directoryIdForNewUsers;
        this.enforceResponseValidityDates = enforceResponseValidityDates;
        this.clockSkew = clockSkew;
        if (base64encodedCertificate == null || base64encodedCertificate.trim().isEmpty()) {
            this.idpSignatureValidator = null;
            logger.warn("No certificate specified for Idp {}.", (Object)issuerIdP);
        } else {
            publicCredential = new BasicX509Credential();
            certificates = X509Util.decodeCertificate(base64encodedCertificate.getBytes());
            idpCertificate = certificates.iterator().next();
            pk = idpCertificate.getPublicKey();
            publicCredential.setPublicKey(pk);
            this.idpSignatureValidator = new SignatureValidator(publicCredential);
        }
        if (secondBase64encodedCertificate == null || secondBase64encodedCertificate.trim().isEmpty()) {
            this.secondIdpSignatureValidator = null;
            logger.debug("No second certificate specified for Idp {}.", (Object)issuerIdP);
        } else {
            publicCredential = new BasicX509Credential();
            certificates = X509Util.decodeCertificate(secondBase64encodedCertificate.getBytes());
            idpCertificate = certificates.iterator().next();
            pk = idpCertificate.getPublicKey();
            publicCredential.setPublicKey(pk);
            this.secondIdpSignatureValidator = new SignatureValidator(publicCredential);
        }
        boolean bl = this.skipCertificateValidation = this.idpSignatureValidator == null && this.secondIdpSignatureValidator == null;
        if (this.skipCertificateValidation) {
            logger.warn("No certificate specified for IdP {}, responses will not be validated!", (Object)issuerIdP);
        }
    }

    public String createSAMLAuthenticationRequest(String issuerUrl) throws SAMLProcessorException {
        logger.debug("Building request message...");
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "samlp");
        if (issuerUrl == null || issuerUrl.isEmpty()) {
            issuerUrl = this.consumerURL;
        }
        issuer.setValue(issuerUrl);
        DateTime issueInstant = new DateTime();
        AuthnRequestBuilder authRequestBuilder = new AuthnRequestBuilder();
        AuthnRequest authRequest = authRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
        authRequest.setVersion(SAMLVersion.VERSION_20);
        authRequest.setIssueInstant(issueInstant);
        authRequest.setAssertionConsumerServiceURL(issuerUrl);
        authRequest.setDestination(this.idpUrl);
        authRequest.setIssuer(issuer);
        if (!this.omitRequestedAuthnContext) {
            AuthnContextClassRefBuilder authnContextClassRefBuilder = new AuthnContextClassRefBuilder();
            AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef", "saml");
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
            RequestedAuthnContextBuilder requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
            RequestedAuthnContext requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
            requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
            requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
            authRequest.setRequestedAuthnContext(requestedAuthnContext);
        }
        authRequest.setID(SingleIdpSAMLProcessor.createID());
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authRequest);
        try {
            Element authDOM = marshaller.marshall(authRequest);
            if (logger.isDebugEnabled()) {
                logger.debug(SAMLProcessor.elementToString(authRequest.getDOM()));
            }
            StringWriter rspWrt = new StringWriter();
            XMLHelper.writeNode((Node)authDOM, rspWrt);
            String responseXML = rspWrt.toString();
            return responseXML;
        }
        catch (MarshallingException e) {
            throw new SAMLProcessorException(e);
        }
    }

    public boolean validateSignature(Signature signature) {
        if (signature == null) {
            logger.debug("Signature is null");
            return false;
        }
        try {
            this.signatureProfileValidator.validate(signature);
        }
        catch (ValidationException e) {
            logger.warn("Signature Profile validation failed", (Throwable)e);
            return false;
        }
        boolean firstSucceeded = false;
        if (this.idpSignatureValidator != null) {
            try {
                this.idpSignatureValidator.validate(signature);
                firstSucceeded = true;
            }
            catch (ValidationException e) {
                logger.warn("Validation against first certificate failed", (Throwable)e);
                firstSucceeded = false;
            }
        }
        boolean secondSucceeded = false;
        if (!firstSucceeded && this.secondIdpSignatureValidator != null) {
            try {
                this.secondIdpSignatureValidator.validate(signature);
                secondSucceeded = true;
            }
            catch (ValidationException e) {
                logger.warn("Validation against second certificate failed", (Throwable)e);
                secondSucceeded = false;
            }
        }
        return firstSucceeded || secondSucceeded;
    }

    public void validateResponseDates(Assertion assertion) throws SAMLProcessorException {
        DateTime now = new DateTime();
        boolean foundNotBefore = false;
        boolean foundNotOnOrAfter = false;
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            logger.debug("Response contains no Conditions");
        } else {
            DateTime notOnOrAfter;
            DateTime notBefore = conditions.getNotBefore();
            if (notBefore != null) {
                foundNotBefore = true;
                if (now.isBefore((ReadableInstant)notBefore.minusSeconds(this.clockSkew))) {
                    throw new SAMLProcessorException("SAMLResponse with NotBefore " + notBefore.toString() + " is not valid yet");
                }
            }
            if ((notOnOrAfter = conditions.getNotOnOrAfter()) != null) {
                foundNotOnOrAfter = true;
                if (now.isAfter((ReadableInstant)notOnOrAfter.plusSeconds(this.clockSkew))) {
                    throw new SAMLProcessorException("SAMLResponse with NotOnOrAfter " + notOnOrAfter.toString() + " is expired");
                }
            }
        }
        Subject subject = assertion.getSubject();
        if (subject == null) {
            logger.warn("Assertion contains no Subject!");
        } else {
            List<SubjectConfirmation> subjectConfirmations = subject.getSubjectConfirmations();
            if (subjectConfirmations != null) {
                for (SubjectConfirmation subjectConfirmation : subjectConfirmations) {
                    DateTime notOnOrAfter;
                    SubjectConfirmationData subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData();
                    if (subjectConfirmationData == null) continue;
                    DateTime notBefore = subjectConfirmationData.getNotBefore();
                    if (notBefore != null) {
                        foundNotBefore = true;
                        if (now.isBefore((ReadableInstant)notBefore.minusSeconds(this.clockSkew))) {
                            throw new SAMLProcessorException("SAMLResponse with NotBefore " + notBefore.toString() + " is not valid yet");
                        }
                    }
                    if ((notOnOrAfter = subjectConfirmationData.getNotOnOrAfter()) == null) continue;
                    foundNotOnOrAfter = true;
                    if (!now.isAfter((ReadableInstant)notOnOrAfter.plusSeconds(this.clockSkew))) continue;
                    throw new SAMLProcessorException("SAMLResponse with NotOnOrAfter " + notOnOrAfter.toString() + " is expired");
                }
            }
        }
        if (!foundNotOnOrAfter) {
            logger.warn("No NotOnOrAfter-attribute found in SAMLResponse, not validating this.");
        }
        if (!foundNotBefore) {
            logger.warn("No NotBefore-attribute found in SAMLResponse, not validating this.");
        }
    }

    public SAMLResponseContent processSAMLResponse(Response response) throws SAMLProcessorException {
        HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
        try {
            List valueList;
            String userid;
            String nameid;
            boolean responseSignatureValid = this.validateSignature(response.getSignature());
            SignableXMLObject assertion = null;
            List<Assertion> assertions = response.getAssertions();
            if (assertions != null && assertions.size() > 0) {
                assertion = response.getAssertions().get(0);
            }
            if (assertion == null) {
                logger.warn("Response contains no assertion");
                return new SAMLResponseContent(false, null, "Response contains no assertion", attributeMap, this.updateUser, this.removeFromGroups, this.updateExisting, this.directoryForNewUsers);
            }
            if (this.enforceResponseValidityDates) {
                this.validateResponseDates((Assertion)assertion);
            }
            boolean assertionSignatureValid = this.validateSignature(assertion.getSignature());
            if (!responseSignatureValid && !assertionSignatureValid) {
                if (this.skipCertificateValidation) {
                    logger.warn("Could not validate Signature, but signature validation is disabled, so we just trust this response");
                } else {
                    throw new SAMLProcessorException("Neither Response nor Assertion contains a valid signature");
                }
            }
            String reason = null;
            try {
                nameid = assertion.getSubject().getNameID().getValue();
            }
            catch (NullPointerException e) {
                nameid = null;
                logger.warn("Assertion contains no Subject with a NameID value");
                reason = "Assertion contains no Subject with a NameID value";
            }
            for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    String name = attribute.getName();
                    ArrayList<String> values = new ArrayList<String>();
                    for (XMLObject attValueObject : attribute.getAttributeValues()) {
                        String value = attValueObject.getDOM().getTextContent();
                        values.add(value);
                    }
                    attributeMap.put(name, values);
                }
            }
            if (this.useridAttribute == null || this.useridAttribute.trim().isEmpty()) {
                userid = nameid;
            } else {
                List attrValues = (List)attributeMap.get(this.useridAttribute);
                if (attrValues != null && !attrValues.isEmpty()) {
                    userid = (String)attrValues.get(0);
                } else {
                    logger.error("No userid value in attribute {}", (Object)this.useridAttribute);
                    reason = "No userid value in attribute " + this.useridAttribute;
                    userid = null;
                }
            }
            if (userid != null && this.useridTransformationRegex != null && !this.useridTransformationRegex.isEmpty()) {
                userid = userid.replaceAll(this.useridTransformationRegex, this.useridTransformationReplacement);
            }
            if (userid != null && this.lowercaseConvert) {
                userid = userid.toLowerCase();
            }
            String fullName = null;
            String emailAddress = null;
            ArrayList<String> groups = new ArrayList<String>(this.defaultGroups.size());
            groups.addAll(this.defaultGroups);
            ArrayList<String> sdCustomerGroups = new ArrayList<String>(this.defaultSdCustomerGroups.size());
            sdCustomerGroups.addAll(this.defaultSdCustomerGroups);
            if (this.fullNameAttribute != null) {
                fullName = FieldCombiner.replaceFields(this.fullNameAttribute, attributeMap);
            }
            if (this.emailAttribute != null) {
                emailAddress = FieldCombiner.replaceFields(this.emailAttribute, attributeMap);
            }
            if (this.groupAttribute != null && (valueList = (List)attributeMap.get(this.groupAttribute)) != null) {
                for (String value : valueList) {
                    if (groups.contains(value)) continue;
                    if (this.lowercaseConvertGroups) {
                        value = value.toLowerCase();
                    }
                    groups.add(value);
                    sdCustomerGroups.add(value);
                }
            }
            return new SAMLResponseContent(userid != null, userid, reason, fullName, emailAddress, groups, sdCustomerGroups, attributeMap, this.updateUser, this.removeFromGroups, this.updateExisting, this.directoryForNewUsers);
        }
        catch (Exception e) {
            throw new SAMLProcessorException(e);
        }
    }

    public String buildRedirectToIdPurl(HttpServletRequest request, String originalUrl, String issuerUrl, Map<String, String> parametersToPassthrough) throws SAMLProcessorException {
        try {
            String requestXML = this.createSAMLAuthenticationRequest(issuerUrl);
            byte[] compressedRequest = SingleIdpSAMLProcessor.compressSamlRequest(requestXML);
            String base64EncodedRequest = SingleIdpSAMLProcessor.encodeBase64(compressedRequest);
            String urlEncodedRequestMessage = URLEncoder.encode(base64EncodedRequest, "ISO-8859-1");
            String urlEncodedOriginalUrl = URLEncoder.encode(originalUrl, "ISO-8859-1");
            String paramIndicator = "?";
            if (this.idpUrl.contains("?")) {
                paramIndicator = "&";
            }
            String retMessage = this.idpUrl + paramIndicator + "SAMLRequest=" + urlEncodedRequestMessage + "&" + this.relayStateParameterName + "=" + urlEncodedOriginalUrl;
            for (String param : parametersToPassthrough.keySet()) {
                retMessage = retMessage + "&" + param + "=" + parametersToPassthrough.get(param);
            }
            return retMessage;
        }
        catch (IOException e) {
            throw new SAMLProcessorException(e);
        }
    }

    public void validateParameter(String param) throws IllegalArgumentException {
        if (param.contains(">") || param.contains("<") || param.contains("\"")) {
            throw new IllegalArgumentException("Value " + param + " is invalid");
        }
    }

    public String buildPOSTtoIdPFormHtml(String originalUrl, String issuerUrl, Map<String, String> parametersToPassthrough) throws SAMLProcessorException {
        try {
            this.validateParameter(originalUrl);
            String request = this.createSAMLAuthenticationRequest(issuerUrl);
            String encodedRequest = SingleIdpSAMLProcessor.encodeBase64(request.getBytes());
            StringBuffer retBuffer = new StringBuffer();
            logger.debug("Creating HTML Form for IdP redirect");
            retBuffer.append("<body>");
            retBuffer.append("<p>Please wait, we're redirecting you...</p>");
            retBuffer.append("<form method=\"POST\" enctype=\"application/x-www-form-urlencoded\" action=\"");
            retBuffer.append(this.idpUrl);
            retBuffer.append("\"/>");
            retBuffer.append("<input type=\"HIDDEN\" name=\"SAMLRequest\" value=\"");
            retBuffer.append(encodedRequest);
            retBuffer.append("\"/>");
            if (this.relayStateParameterName != null && this.relayStateParameterName.length() > 0) {
                retBuffer.append("<input type=\"HIDDEN\" name=\"");
                retBuffer.append(this.relayStateParameterName);
                retBuffer.append("\" value=\"");
                retBuffer.append(originalUrl);
                retBuffer.append("\"></input>");
            }
            for (String param : parametersToPassthrough.keySet()) {
                this.validateParameter(param);
                String paramValue = parametersToPassthrough.get(param);
                this.validateParameter(paramValue);
                retBuffer.append("<input type=\"HIDDEN\" name=\"");
                retBuffer.append(param);
                retBuffer.append("\" value=\"");
                retBuffer.append(paramValue);
                retBuffer.append("\"></input>");
            }
            retBuffer.append("</form>");
            retBuffer.append("<script type=\"text/javascript\">window.onload = function () { document.forms[0].submit(); }</script>");
            retBuffer.append("</body>");
            return retBuffer.toString();
        }
        catch (Exception e) {
            throw new SAMLProcessorException(e);
        }
    }

    public String transformUserid(String userid) {
        String replacement;
        String regex = this.useridTransformationRegex == null ? "" : this.useridTransformationRegex;
        String string = replacement = this.useridTransformationReplacement == null ? "" : this.useridTransformationReplacement;
        if (regex.isEmpty()) {
            logger.debug("Transformation regex is empty, retuning {}", (Object)userid);
            return userid;
        }
        String transformed = userid.replaceAll(regex, replacement);
        logger.debug("Transformed userid {} to {} using regex {} and replacement {}", (Object[])new String[]{userid, transformed, regex, replacement});
        return transformed;
    }

    public static byte[] compressSamlRequest(String responseXML) throws IOException {
        Deflater deflater = new Deflater(8, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(responseXML.getBytes());
        deflaterOutputStream.close();
        byte[] output = byteArrayOutputStream.toByteArray();
        return output;
    }

    public static String encodeBase64(byte[] data) {
        String encoded = Base64.encodeBytes(data, 9);
        return encoded;
    }

    public static String createID() {
        byte[] bytes = new byte[20];
        new Random().nextBytes(bytes);
        char[] charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        char[] chars = new char[40];
        for (int i = 0; i < bytes.length; ++i) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMapping[left];
            chars[i * 2 + 1] = charMapping[right];
        }
        return String.valueOf(chars);
    }
}

