/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.samlprocessor;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseIDStore {
    private static final int EXPIRE_MINUTES = 60;
    private static final Logger logger = LoggerFactory.getLogger(ResponseIDStore.class);
    private Map<String, DateTime> storageMap = new HashMap<String, DateTime>();

    public boolean contains(String id) {
        return this.storageMap.containsKey(id);
    }

    public void add(String id) {
        this.cleanup();
        DateTime now = new DateTime();
        DateTime keepUntil = now.plusMinutes(60);
        this.storageMap.put(id, keepUntil);
    }

    private void cleanup() {
        HashMap<String, DateTime> newStorageMap = new HashMap<String, DateTime>();
        DateTime now = new DateTime();
        for (String key : this.storageMap.keySet()) {
            DateTime value = this.storageMap.get(key);
            if (!value.isAfter((ReadableInstant)now)) continue;
            newStorageMap.put(key, value);
        }
        if (logger.isDebugEnabled()) {
            int oldSize = this.storageMap.size();
            int newSize = newStorageMap.size();
            if (newSize < oldSize) {
                logger.debug("Removed {} outdated entires", (Object)(oldSize - newSize));
            }
        }
        this.storageMap = newStorageMap;
    }
}

