/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.samlprocessor;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCombiner {
    public static final Logger logger = LoggerFactory.getLogger(FieldCombiner.class);

    public static String replaceFields(String stringToReplace, Map<String, List<String>> attributeMap) throws ParseException {
        if (stringToReplace.contains("{")) {
            List<String> fieldNames = FieldCombiner.getFieldNames(stringToReplace);
            String ret = stringToReplace;
            for (String currentName : fieldNames) {
                String value = FieldCombiner.getFirstAttributeValue(currentName, attributeMap);
                if (value == null) {
                    value = "";
                }
                ret = ret.replaceAll("\\{" + currentName + "\\}", value);
            }
            return ret;
        }
        return FieldCombiner.getFirstAttributeValue(stringToReplace, attributeMap);
    }

    public static void testString(String stringToTest) throws ParseException {
        if (stringToTest != null && !stringToTest.isEmpty()) {
            HashMap<String, List<String>> emptyMap = new HashMap<String, List<String>>();
            FieldCombiner.replaceFields(stringToTest, emptyMap);
        }
    }

    public static String getFirstAttributeValue(String name, Map<String, List<String>> attributeMap) {
        List<String> valueList = attributeMap.get(name);
        if (valueList != null && !valueList.isEmpty()) {
            return valueList.get(0);
        }
        return null;
    }

    public static List<String> getFieldNames(String attributeString) throws ParseException {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = attributeString.toCharArray();
        StringBuffer currentSb = null;
        State state = State.NONE;
        block12: for (int i = 0; i < chars.length; ++i) {
            char currentChar = chars[i];
            switch (state) {
                case NONE: {
                    switch (currentChar) {
                        case '{': {
                            state = State.OPEN;
                            currentSb = new StringBuffer();
                            continue block12;
                        }
                        case '}': {
                            throw new ParseException("Unexpected } at position " + i, i);
                        }
                    }
                    continue block12;
                }
                case OPEN: {
                    switch (currentChar) {
                        case '}': {
                            state = State.NONE;
                            ret.add(currentSb.toString());
                            currentSb = new StringBuffer();
                            continue block12;
                        }
                        case '{': {
                            throw new ParseException("Unexpected { at position " + i, i);
                        }
                    }
                    currentSb.append(currentChar);
                    continue block12;
                }
                default: {
                    throw new ParseException("Invalid state while parsing attributeString. This should never happen", i);
                }
            }
        }
        if (state != State.NONE) {
            throw new ParseException("Missing closing }", attributeString.length() - 1);
        }
        return ret;
    }

    private static enum State {
        NONE,
        OPEN;

    }
}

