/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.license;

import com.resolution.license.EmptyLicense;
import com.resolution.license.Feature;
import com.resolution.license.License;
import com.resolution.license.XMLFeature;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlRootElement(name="license")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SignedXMLLicense
implements License {
    private static final Logger logger = LoggerFactory.getLogger(SignedXMLLicense.class);
    public static final String KEYALIAS = "signlicense";
    public static final String KEYSTORE = "/com/resolution/license/licenseValidation.jks";
    public static final String KEYSTOREPASS = "validate";
    public static final String ANYFEATURE = "any";
    @XmlElementWrapper(name="features")
    @XmlElement(name="feature")
    private List<XMLFeature> featureList;
    private Date validUntil;
    private Date issuedDate;
    private String issuedTo;
    private String issuedBy;
    private String hostId;
    @XmlTransient
    private boolean signatureValid = false;
    @XmlTransient
    private boolean modifiedAfterSignature = false;
    @XmlTransient
    private boolean signatureKeyMismatch = false;

    public static SignedXMLLicense readLicense(String xmlString) {
        try {
            return SignedXMLLicense.readLicense(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SignedXMLLicense readLicense(File pathToXML) {
        SignedXMLLicense ret;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(pathToXML);
            ret = SignedXMLLicense.readLicense(inStream);
        }
        catch (FileNotFoundException e) {
            logger.error("License file not found: " + e.getMessage());
            logger.warn("Creating empty license");
            return new EmptyLicense();
        }
        try {
            ((InputStream)inStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static SignedXMLLicense readLicense(InputStream inStream) {
        SignedXMLLicense license;
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            doc = dbf.newDocumentBuilder().parse(inStream);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SignedXMLLicense.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            license = (SignedXMLLicense)unmarshaller.unmarshal(doc.getFirstChild());
        }
        catch (Exception e) {
            logger.error("Error reading license file: " + e.getClass() + ": " + e.getMessage());
            logger.warn("Creating empty license");
            EmptyLicense license2 = new EmptyLicense();
            return license2;
        }
        NodeList signatureNodeList = doc.getElementsByTagName("Signature");
        if (signatureNodeList.getLength() == 0) {
            logger.error("No signature found in license!");
            license.signatureValid = false;
            return license;
        }
        Node signatureNode = signatureNodeList.item(0);
        DOMValidateContext validateContext = new DOMValidateContext(new LicenseSigningCertificateSelector(), signatureNode);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        try {
            XMLSignature signature = fac.unmarshalXMLSignature(validateContext);
            license.signatureValid = signature.validate(validateContext);
            if (!license.signatureValid) {
                boolean signatureValueStatus = signature.getSignatureValue().validate(validateContext);
                if (signatureValueStatus) {
                    license.modifiedAfterSignature = true;
                    license.signatureKeyMismatch = false;
                } else {
                    license.signatureValid = false;
                    license.signatureKeyMismatch = true;
                }
            }
        }
        catch (Exception e) {
            logger.error("License signature validation failed.");
            license.signatureValid = false;
        }
        return license;
    }

    @Override
    public List<Feature> getFeatures() {
        LinkedList<Feature> ret = new LinkedList<Feature>();
        for (Feature feature : this.featureList) {
            ret.add(feature);
        }
        return ret;
    }

    @Override
    public Feature getFeature(final String name) {
        for (Feature feature : this.featureList) {
            if (feature.getName().equals(name)) {
                return feature;
            }
            if (!feature.getName().equals(ANYFEATURE)) continue;
            return new Feature(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getDescription() {
                    return "License covers any feature.";
                }

                @Override
                public int getCount() {
                    return Integer.MAX_VALUE;
                }

                public String toString() {
                    return this.getName() + ":" + this.getDescription() + ":" + this.getCount();
                }
            };
        }
        return null;
    }

    @Override
    public Date getIssuedDate() {
        return this.issuedDate;
    }

    @Override
    public Date getValidUntil() {
        return this.validUntil;
    }

    @Override
    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    @Override
    public boolean isFeatureLicensed(String featureName) {
        Feature feature = this.getFeature(featureName);
        return feature != null;
    }

    @Override
    public boolean isFeatureLicensed(String featureName, int count) {
        Feature feature = this.getFeature(featureName);
        if (feature == null) {
            return false;
        }
        return feature.getCount() >= count;
    }

    @Override
    public boolean isValidForHost(String hostid) {
        if (this.hostId == null) {
            return true;
        }
        if (hostid == null) {
            return false;
        }
        return hostid.equals(this.hostId);
    }

    public boolean isModifiedAfterSignature() {
        return this.modifiedAfterSignature;
    }

    public boolean isSignatureKeyMismatch() {
        return this.signatureKeyMismatch;
    }

    public boolean isLoadSuccessful() {
        return true;
    }

    @Override
    public String getHostId() {
        return this.hostId;
    }

    @Override
    public boolean isValid() {
        return this.signatureValid && this.isBeforeValidUntil();
    }

    @Override
    public boolean isBeforeValidUntil() {
        if (this.validUntil == null) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        now.add(5, 1);
        Date tomorrow = now.getTime();
        return tomorrow.before(this.validUntil);
    }

    @Override
    public String getIssuedTo() {
        return this.issuedTo;
    }

    @Override
    public String getIssuedBy() {
        return this.issuedBy;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Issued to:       " + this.issuedTo + "\n");
        ret.append("Issued by:       " + this.issuedBy + "\n");
        ret.append("Issued date:     " + new SimpleDateFormat().format(this.getIssuedDate()) + "\n");
        ret.append("Valid until:     " + new SimpleDateFormat().format(this.getValidUntil()) + "\n");
        ret.append("Host ID:     " + this.getHostId() + "\n");
        ret.append("Signature valid: " + this.signatureValid + "\n");
        ret.append("License valid:   " + this.isValid() + "\n");
        ret.append("Features licensed:\n");
        List<Feature> featureList = this.getFeatures();
        for (Feature feature : featureList) {
            ret.append("  " + feature.getCount() + ": " + feature.getName() + ": " + feature.getDescription() + "\n");
        }
        return ret.toString();
    }

    public static class LicenseSigningCertificateSelector
    extends KeySelector {
        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(LicenseSigningCertificateSelector.class.getResourceAsStream(SignedXMLLicense.KEYSTORE), SignedXMLLicense.KEYSTOREPASS.toCharArray());
                Certificate cert = ks.getCertificate(SignedXMLLicense.KEYALIAS);
                final PublicKey publicKey = cert.getPublicKey();
                return new KeySelectorResult(){

                    @Override
                    public Key getKey() {
                        return publicKey;
                    }
                };
            }
            catch (Exception e) {
                throw new KeySelectorException(e);
            }
        }
    }
}

