/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.license;

import com.resolution.license.SignedXMLLicense;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LicenseSigner {
    public static final String KEYALIAS = "signlicense";

    public static void main(String[] args) {
        if (args.length > 1 && args[0].equals("check")) {
            System.out.println("Checking license in " + args[1]);
            SignedXMLLicense lic = SignedXMLLicense.readLicense(new File(args[1]));
            System.out.println(lic);
            return;
        }
        if (args.length < 2) {
            System.out.println("Need 2 arguments: <XML-file to sign> <password for keystore> optional <keystore file>");
            return;
        }
        String filename = args[0];
        String password = args[1];
        String keystorefile = "licenseSigningKey.jks";
        if (args.length > 2) {
            keystorefile = args[2];
        }
        String outfilename = filename.replaceAll("\\.xml$", ".sgn.xml");
        try {
            LicenseSigner.signLicense(keystorefile, password, filename, outfilename);
            System.out.println("Stored signed license in " + outfilename);
            SignedXMLLicense license = SignedXMLLicense.readLicense(new File(outfilename));
            System.out.println(((Object)license).toString());
        }
        catch (Exception e) {
            System.out.println("Signing license failed: " + e.getMessage());
        }
    }

    public static void signLicense(String keystorefile, String keystorepassword, String licenseFile, String outputFile) throws Exception {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(keystorefile), keystorepassword.toCharArray());
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(KEYALIAS, new KeyStore.PasswordProtection(keystorepassword.toCharArray()));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(licenseFile));
        DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)doc.getDocumentElement());
        XMLSignature signature = fac.newXMLSignature(si, null);
        signature.sign(dsc);
        FileOutputStream os = new FileOutputStream(outputFile);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
    }
}

