/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.license;

import com.resolution.license.License;
import com.resolution.license.SignedXMLLicense;
import java.io.File;
import java.io.InputStream;

public class LicenseFactory {
    public static final String DEFAULT_LICENSE_FILENAME = "/license.sgn.xml";

    public static License loadLicense(File licenseFile) {
        return SignedXMLLicense.readLicense(licenseFile);
    }

    public static License loadLicense(String pathToFile) {
        return LicenseFactory.loadLicense(new File(pathToFile));
    }

    public static License loadLicense(InputStream in) {
        return SignedXMLLicense.readLicense(in);
    }

    public static License loadLicenseFromClasspath() {
        return LicenseFactory.loadLicenseFromClasspath(DEFAULT_LICENSE_FILENAME);
    }

    public static License loadLicenseFromString(String licString) {
        return SignedXMLLicense.readLicense(licString);
    }

    public static License loadLicenseFromClasspath(String filename) {
        if (!filename.startsWith("/")) {
            filename = "/" + filename;
        }
        InputStream in = LicenseFactory.class.getResourceAsStream(filename);
        return LicenseFactory.loadLicense(in);
    }
}

