/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.AuthenticatorHookException;
import com.resolution.atlasplugins.samlsso.LicenseChecker;
import com.resolution.atlasplugins.samlsso.SSOTokenStore;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.UserPreparationException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.samlprocessor.SAMLProcessor;
import com.resolution.samlprocessor.SAMLProcessorException;
import com.resolution.samlprocessor.SAMLResponseContent;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlSsoServlet
extends BasicServlet {
    private static final Logger logger = LoggerFactory.getLogger(SamlSsoServlet.class);
    private final LicenseChecker licenseChecker;
    public static final String IDP_COOKIE_NAME = "selectedidp";
    public static final int IDP_COOKIE_LIFETIME = 31536000;
    public static final String SSO_TOKEN_PARAMETER = "ssoservlettoken";
    public static final String SESSION_ATTRIBUTE_SUCCESS = "SAMLSSO-SUCCESS";
    public static final String SESSION_ATTRIBUTE_FAILURE = "SAMLSSO-FAILURE";
    private final SSOTokenStore tokenStore;
    private static final long serialVersionUID = 1L;

    public SamlSsoServlet(SamlSsoService samlSsoService, PluginConfiguration pluginConfiguration, LicenseChecker licenseChecker, TemplateRenderer renderer) {
        super(samlSsoService, pluginConfiguration, renderer);
        this.licenseChecker = licenseChecker;
        this.tokenStore = SSOTokenStore.getInstance();
    }

    @Override
    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block17: {
            HttpSession session = req.getSession();
            Object success = session.getAttribute(SESSION_ATTRIBUTE_SUCCESS);
            session.removeAttribute(SESSION_ATTRIBUTE_SUCCESS);
            String failure = (String)session.getAttribute(SESSION_ATTRIBUTE_FAILURE);
            session.removeAttribute(SESSION_ATTRIBUTE_FAILURE);
            if (success != null) {
                this.sendServiceDeskError(resp, "Success marker was found in session, seems like you wanted to logout");
                return;
            }
            if (failure != null) {
                this.sendServiceDeskError(resp, failure);
                return;
            }
            boolean alreadyAuthenticated = "success".equals(req.getAttribute("os_authstatus"));
            if (logger.isDebugEnabled()) {
                if (alreadyAuthenticated) {
                    logger.debug("Request is already authenticated");
                } else {
                    logger.debug("Request is NOT authenticated");
                }
            }
            if (!this.samlSsoService.isInitialized()) {
                logger.error("SAMLSsoComponent is not initialized!");
                this.sendError(resp, null, "SAMLSsoComponent is not initialized. Check logs for details.", null);
                return;
            }
            LicenseChecker.LicenseCheckResult lc = this.licenseChecker.checkLicense();
            if (!lc.isLicensed()) {
                this.sendError(resp, null, lc.getMessage(), null);
                return;
            }
            String token = req.getParameter(SSO_TOKEN_PARAMETER);
            if (token != null) {
                logger.debug("Loading userid from token");
                String userid = this.tokenStore.getUseridFromSsoToken(token);
                if (userid == null) {
                    logger.warn("Could not find a userid with token {}", (Object)token);
                    this.sendError(resp, null, "Could not find a userid for the token provided", null);
                } else {
                    try {
                        logger.debug("Trying to authorize user " + userid);
                        boolean authenticationSuccessful = false;
                        authenticationSuccessful = this.samlSsoService.getAuthenticatorHook().authoriseUserAndEstablishSession(req, resp, userid, this.pluginConfiguration.isSetRememberMeCookie());
                        if (authenticationSuccessful) {
                            String redirectTo = req.getParameter("RelayState");
                            String decoded = URLDecoder.decode(redirectTo, "UTF-8");
                            logger.debug("Redirecting to " + decoded);
                            resp.sendRedirect(decoded);
                            break block17;
                        }
                        this.sendError(resp, userid, null, null);
                    }
                    catch (AuthenticatorHookException e) {
                        String message = e.getMessage();
                        if (message == null) {
                            message = e.getCause().getClass().getName() + ": " + e.getCause().getMessage();
                        }
                        logger.error("Authenticating user failed: ", (Throwable)e);
                        this.sendError(resp, null, message, e);
                    }
                }
            } else {
                String samlResponse = req.getParameter("SAMLResponse");
                if (samlResponse == null) {
                    this.processRequestFromClient(req, resp);
                } else {
                    this.processRequestFromIdP(req, resp, samlResponse);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processRequestFromClient(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug("We have no SAML Response, so this request comes from the Client");
        SAMLProcessor samlProcessor = this.samlSsoService.getSamlProcessor();
        String defaultRedirectUrl = this.pluginConfiguration.getDefaultRedirectUrl();
        String originalUrl = req.getParameter("redirectTo");
        if (originalUrl == null || originalUrl.equals("null")) {
            logger.debug("No original URL in request, using {}", (Object)defaultRedirectUrl);
            originalUrl = defaultRedirectUrl;
        }
        logger.debug("Original url is {}", (Object)originalUrl);
        String issuerUrl = req.getParameter("issuer");
        if (issuerUrl != null && issuerUrl.isEmpty()) {
            issuerUrl = null;
        }
        if (req.getParameter("selectidp") != null) {
            logger.debug("selectidp parameter is present, rendering selection page");
            this.sendIdpSelectionPage(resp, originalUrl, 0);
            return;
        }
        if (req.getParameter("idpbyemail") != null) {
            logger.debug("idpbyemail parameter is present, rendering selection by email page");
            this.sendIdpSelectionByEmailPage(resp, originalUrl);
            return;
        }
        int idpid = 0;
        int idpidFromCookie = 0;
        String idpIdString = req.getParameter("idp");
        if (idpIdString != null) {
            try {
                idpid = Integer.parseInt(idpIdString);
            }
            catch (NumberFormatException e) {
                logger.error("IDP id {} is invalid", (Object)idpIdString);
                this.sendError(resp, null, "IDP id " + idpIdString + "is invalid", e);
                return;
            }
        } else {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(IDP_COOKIE_NAME)) continue;
                    if (cookies[i].getValue() == null) break;
                    try {
                        idpidFromCookie = Integer.parseInt(cookies[i].getValue());
                        logger.debug("Found idp {} in cookie", (Object)idpidFromCookie);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Cookie value {} is not parseable, setting id to 0.", (Object)cookies[i].getValue());
                        idpidFromCookie = 0;
                    }
                    break;
                }
            }
        }
        if (idpid == 0) {
            if (this.pluginConfiguration.isEnableIdPSelection()) {
                this.sendIdpSelectionPage(resp, originalUrl, idpidFromCookie);
                return;
            }
            if (this.pluginConfiguration.isEnableIdPSelectionByEmailAddress()) {
                if (idpidFromCookie == 0) {
                    this.sendIdpSelectionByEmailPage(resp, originalUrl);
                    return;
                }
                idpid = idpidFromCookie;
            } else {
                logger.debug("Using default IdP 1");
                idpid = 1;
            }
        } else {
            Cookie newCookie = new Cookie(IDP_COOKIE_NAME, String.valueOf(idpid));
            newCookie.setMaxAge(31536000);
            resp.addCookie(newCookie);
        }
        Enumeration paramNames = req.getParameterNames();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (paramName.equals("redirectTo")) continue;
            paramMap.put(paramName, req.getParameter(paramName));
        }
        try {
            if (this.pluginConfiguration.isRedirectWithPOST()) {
                logger.debug("redirectWithPOST is active, rendering the auto-submitting form to redirect to the IdP:");
                String redirectForm = samlProcessor.buildPOSTtoIdPFormHtml(originalUrl, idpid, issuerUrl, paramMap);
                logger.debug(redirectForm);
                resp.setContentType("text/html;charset=utf-8");
                PrintWriter out = resp.getWriter();
                out.write(redirectForm);
                out.close();
                return;
            }
            String samlRequest = samlProcessor.buildRedirectToIdPurl(req, originalUrl, idpid, issuerUrl, paramMap);
            logger.debug("Redirecting to: " + samlRequest);
            resp.sendRedirect(samlRequest);
            return;
        }
        catch (SAMLProcessorException e) {
            logger.error("SAML Processor threw exception", (Throwable)e);
            this.sendError(resp, null, "Processing saml failed: " + e.getMessage(), null);
            return;
        }
    }

    private void processRequestFromIdP(HttpServletRequest req, HttpServletResponse resp, String samlResponse) throws ServletException, IOException {
        block23: {
            String baseUrl = this.samlSsoService.getAbsoluteBaseUrl();
            String defaultRedirectUrl = this.pluginConfiguration.getDefaultRedirectUrl();
            SAMLProcessor samlProcessor = this.samlSsoService.getSamlProcessor();
            logger.debug("We have a SAML Response, so this request comes from the IdP");
            try {
                String fullRedirectUrl;
                SAMLResponseContent responseContent = samlProcessor.processSAMLResponseMessage(samlResponse);
                if (!responseContent.isSuccess()) {
                    this.sendError(resp, null, responseContent.getReason(), null);
                    break block23;
                }
                String userid = responseContent.getUserid();
                String originalUrl = req.getParameter("RelayState");
                logger.debug("RelayState parameter is " + originalUrl);
                if (originalUrl == null || originalUrl.length() == 0) {
                    originalUrl = defaultRedirectUrl;
                    logger.warn("No original URL found in the request, redirecting to " + originalUrl);
                }
                if (!(fullRedirectUrl = originalUrl.startsWith("/") ? baseUrl + originalUrl : originalUrl).startsWith(baseUrl)) {
                    logger.warn("Redirect URL {} is invalid!", (Object)fullRedirectUrl);
                    String message = "Redirect URL " + fullRedirectUrl + " does not belong to the base URL " + baseUrl + ", not redirecting.";
                    this.sendError(resp, null, message, null);
                    return;
                }
                if (fullRedirectUrl.contains("@")) {
                    logger.warn("Redirect URL {} is invalid!", (Object)fullRedirectUrl);
                    String message = "Redirect URL " + fullRedirectUrl + " contains invalid @-character, not redirecting.";
                    this.sendError(resp, null, message, null);
                    return;
                }
                logger.debug("Redirect URL {} is valid");
                if (fullRedirectUrl.contains("/servicedesk/customer")) {
                    boolean hasAuthenticator = this.samlSsoService.checkForSamlSsoAuthenticator();
                    if (hasAuthenticator) {
                        if (fullRedirectUrl.contains("samlssotoken=")) {
                            fullRedirectUrl = fullRedirectUrl.replaceAll("samlssotoken=.*&", "");
                            fullRedirectUrl = fullRedirectUrl.replaceAll("samlssotoken=.*$", "");
                            fullRedirectUrl = fullRedirectUrl.replaceAll("\\?$", "");
                            logger.debug("removed existing samlssotoken from URL {}", (Object)fullRedirectUrl);
                        }
                        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
                        logger.debug("We have a SamlSsoAuthenticator, redirecting to {} with samlssotoken-parameter", (Object)fullRedirectUrl);
                        try {
                            Method method = authenticator.getClass().getMethod("getSsoToken", String.class);
                            Object ret = method.invoke((Object)authenticator, userid);
                            logger.debug("getSsoToken returned {}", ret);
                            if (!(ret instanceof String)) {
                                throw new SAMLProcessorException("addUserToSsoMap did not return a String but a " + ret.getClass().getName());
                            }
                            String ssoToken = (String)ret;
                            String redirectUrlWithToken = fullRedirectUrl.contains("?") ? fullRedirectUrl + "&samlssotoken=" + ssoToken : fullRedirectUrl + "?samlssotoken=" + ssoToken;
                            logger.debug("Redirecting to {}", (Object)redirectUrlWithToken);
                            this.samlSsoService.prepareUser(responseContent, true, true);
                            resp.sendRedirect(redirectUrlWithToken);
                            break block23;
                        }
                        catch (NoSuchMethodException e) {
                            throw new SAMLProcessorException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new SAMLProcessorException(e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new SAMLProcessorException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new SAMLProcessorException(e.getCause());
                        }
                    }
                    this.sendError(resp, userid, "SingleSignOn for JIRA Service Desk requires a SamlSsoAuthenticator which is not configured.", null);
                    break block23;
                }
                logger.debug("This is no SamlSsoAuthenticator, using the AuthenticatorHook");
                boolean addedOrUpdated = false;
                try {
                    addedOrUpdated = this.samlSsoService.prepareUser(responseContent, true, false);
                }
                catch (UserPreparationException e) {
                    logger.error("Preparing User failed", (Throwable)e);
                    this.sendError(resp, null, e.getMessage(), e);
                }
                if (addedOrUpdated) {
                    String token = this.tokenStore.getSsoToken(userid);
                    String urlForRedirect = baseUrl + "/plugins/servlet/samlsso?" + SSO_TOKEN_PARAMETER + "=" + token + "&RelayState=" + URLEncoder.encode(fullRedirectUrl, "UTF-8");
                    logger.debug("User is modified, redirecting again to have changes active {}", (Object)urlForRedirect);
                    resp.sendRedirect(urlForRedirect);
                    return;
                }
                try {
                    logger.debug("Trying to authorize user " + userid);
                    boolean authenticationSuccessful = false;
                    authenticationSuccessful = this.samlSsoService.getAuthenticatorHook().authoriseUserAndEstablishSession(req, resp, userid, this.pluginConfiguration.isSetRememberMeCookie());
                    if (authenticationSuccessful) {
                        logger.debug("Redirecting to " + fullRedirectUrl);
                        resp.sendRedirect(fullRedirectUrl);
                        break block23;
                    }
                    this.sendError(resp, userid, null, null);
                }
                catch (AuthenticatorHookException e) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = e.getCause().getClass().getName() + ": " + e.getCause().getMessage();
                    }
                    logger.error("Authenticating user failed: ", (Throwable)e);
                    this.sendError(resp, null, message, e);
                }
            }
            catch (SAMLProcessorException e) {
                logger.error("SAML Processor threw exception", (Throwable)e);
                this.sendError(resp, null, "Processing saml failed: " + e.getMessage(), null);
                return;
            }
            catch (UserPreparationException e) {
                logger.error("Updating or creating user failed.", (Throwable)e);
                this.sendError(resp, null, "Updating or creating user failed. " + e.getMessage(), null);
                return;
            }
        }
    }

    protected void sendIdpSelectionByEmailPage(HttpServletResponse response, String originalUrl) throws ServletException, IOException {
        Cookie cookie = new Cookie(IDP_COOKIE_NAME, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        Map<String, Integer> domainIdMap = this.pluginConfiguration.getEmailDomainIdMap();
        StringBuffer jsonSB = new StringBuffer();
        jsonSB.append("{ ");
        boolean first = true;
        for (String emailDomain : domainIdMap.keySet()) {
            if (first) {
                first = false;
            } else {
                jsonSB.append(",");
            }
            jsonSB.append("\"").append(Utils.hashSHA256(emailDomain)).append("\": ").append(domainIdMap.get(emailDomain));
        }
        jsonSB.append(" }");
        String jsonString = jsonSB.toString();
        HashMap<String, String> ctx = new HashMap<String, String>();
        String ssourl = this.samlSsoService.getConsumerUrl() + "?idp=IDPID&redirectTo=" + URLEncoder.encode(originalUrl, "UTF-8");
        String loginurl = this.samlSsoService.getAbsoluteLoginPageUrl() + "&os_destination=" + URLEncoder.encode(originalUrl, "UTF-8");
        ctx.put("loginurl", loginurl);
        ctx.put("ssourl", ssourl);
        ctx.put("emailDomainMap", jsonString);
        response.setContentType("text/html;charset=utf-8");
        String template = this.pluginConfiguration.getIdpByEmailPageTemplate();
        String result = this.renderer.renderFragment(template, ctx);
        result = Utils.unescapeHTML(result);
        logger.debug(template);
        logger.debug(result);
        response.getWriter().write(result);
    }

    protected void sendIdpSelectionPage(HttpServletResponse resp, String originalUrl, int idpFromCookie) throws ServletException, IOException {
        Cookie cookie = new Cookie(IDP_COOKIE_NAME, "");
        cookie.setMaxAge(0);
        resp.addCookie(cookie);
        String fragment = this.pluginConfiguration.getIdpSelectionPageTemplate();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        String loginurl = this.samlSsoService.getAbsoluteLoginPageUrl() + "&os_destination=" + URLEncoder.encode(originalUrl, "UTF-8");
        ctx.put("loginurl", loginurl);
        ctx.put("ssourl", this.samlSsoService.getSSOUrl());
        String idpUrlFromCookie = null;
        String nameFromCookie = null;
        String descriptionFromCookie = null;
        List<IdpConfiguration> idps = this.pluginConfiguration.getIdpConfigurations();
        for (IdpConfiguration current : idps) {
            String idpurl = this.samlSsoService.getConsumerUrl() + "?idp=" + current.getId() + "&redirectTo=" + URLEncoder.encode(originalUrl, "UTF-8");
            current.setSsoUrl(idpurl);
            if (current.getId() != idpFromCookie) continue;
            idpUrlFromCookie = idpurl;
            nameFromCookie = current.getName();
            descriptionFromCookie = current.getDescription();
        }
        ctx.put("idps", idps);
        ctx.put("selectedUrl", idpUrlFromCookie);
        ctx.put("selectedName", nameFromCookie);
        ctx.put("selectedDescription", descriptionFromCookie);
        ctx.put("idpSelected", idpUrlFromCookie != null);
        logger.debug("Last selected idp is {}", nameFromCookie);
        resp.setContentType("text/html;charset=utf-8");
        String result = this.renderer.renderFragment(fragment, ctx);
        result = Utils.unescapeHTML(result);
        resp.getWriter().write(result);
    }
}

