/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.samlprocessor.SAMLProcessorException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataServlet
extends BasicServlet {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataServlet.class);
    private static final long serialVersionUID = 1935293655352567609L;

    public MetaDataServlet(SamlSsoService samlSsoComponent, PluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        super(samlSsoComponent, pluginConfiguration, renderer);
    }

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String responseString = this.samlSsoService.generateSamlMetadata();
            response.setStatus(200);
            response.setContentType("text/xml;charset=utf-8");
            response.getWriter().write(responseString);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (SAMLProcessorException e) {
            logger.error("Generating Metadata failed", (Throwable)e);
            this.sendError(response, null, null, e);
        }
    }
}

