/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceConfigurationDefaultSetter
extends ConfigurationDefaultSetter {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceConfigurationDefaultSetter.class);
    private final Settings confluenceSettings;

    public ConfluenceConfigurationDefaultSetter(SettingsManager settingsManager) {
        this.confluenceSettings = settingsManager.getGlobalSettings();
    }

    @Override
    public void addDefaults(ConfigurationData configurationData) {
        if (configurationData.nonSsoDestinations == null || configurationData.nonSsoDestinations.trim().isEmpty()) {
            logger.info("Setting nonSsoDestinations to default {}", (Object)"%2Fplugins%2Fservlet%2Fapplinks,applicationlinks");
            configurationData.nonSsoDestinations = "%2Fplugins%2Fservlet%2Fapplinks,applicationlinks";
        }
        if (configurationData.nonSsoUserAgents == null || configurationData.nonSsoUserAgents.trim().isEmpty()) {
            logger.info("Setting nonSsoUserAgents to default {}", (Object)"Jakarta Commons-HttpClient");
            configurationData.nonSsoUserAgents = "Jakarta Commons-HttpClient";
        }
        if (configurationData.enforceSsoDestinations == null || configurationData.enforceSsoDestinations.trim().isEmpty()) {
            logger.info("Setting enforceSsoDestinations to default {}", (Object)"");
            configurationData.enforceSsoDestinations = "";
        }
        super.addDefaults(configurationData);
    }

    @Override
    public void addDefaults(IdpConfiguration idpConfig) {
        super.addDefaults(idpConfig);
        if (idpConfig.getGroupsForNewUsers() == null) {
            idpConfig.setGroupsForNewUsers(this.confluenceSettings.getDefaultUsersGroup());
        }
    }
}

