/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.resolution.atlasplugins.samlsso.cluster.AbstractClusterNotificator;
import com.resolution.atlasplugins.samlsso.confluence.SAMLSsoPluginEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceClusterNotificator
extends AbstractClusterNotificator {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceClusterNotificator.class);
    private final EventPublisher eventPublisher = (EventPublisher)ContainerManager.getComponent((String)"eventPublisher");

    public ConfluenceClusterNotificator() {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public void send(String message) {
        SAMLSsoPluginEvent event = new SAMLSsoPluginEvent(this, message);
        this.eventPublisher.publish((Object)event);
    }

    @EventListener
    public void handleRemoteEvent(ClusterEventWrapper wrapper) {
        if (wrapper.getEvent() instanceof SAMLSsoPluginEvent) {
            String message = ((SAMLSsoPluginEvent)wrapper.getEvent()).getMessage();
            logger.debug("Received SAMLSsoPluginEvent with message {}", (Object)message);
            this.notifiyListeners(message);
        } else {
            logger.debug("Received an Event which is not a SAMLSsoPluginEvent, ignoring it");
        }
    }

    @EventListener
    public void handleLocalEvent(SAMLSsoPluginEvent event) {
        logger.debug("Received local event with message {}, and ignoring it.", (Object)event.getMessage());
    }
}

