/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.resolution.atlasplugins.samlsso.LicenseChecker;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationMigrator;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationValidator;
import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfigurationListener;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfiguration.class);
    private final PluginSettings pluginSettings;
    private final LicenseChecker licenseChecker;
    private final ConfigurationValidator configurationValidator;
    private final ConfigurationDefaultSetter configurationDefaultSetter;
    private final ConfigurationMigrator configurationMigrator;
    private final CrowdDirectoryService crowdDirectoryService;
    protected ConfigurationData configurationData;
    private final Collection<PluginConfigurationListener> configurationListeners;

    public PluginConfiguration(UserManager userManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate, LicenseChecker licenseChecker, ConfigurationValidator configurationValidator, ConfigurationDefaultSetter configurationDefaultSetter, ConfigurationMigrator configurationMigrator, CrowdDirectoryService crowdDirectoryService) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.configurationValidator = configurationValidator;
        this.configurationDefaultSetter = configurationDefaultSetter;
        this.configurationMigrator = configurationMigrator;
        this.licenseChecker = licenseChecker;
        this.configurationListeners = new ArrayList<PluginConfigurationListener>();
        this.crowdDirectoryService = crowdDirectoryService;
        this.load();
    }

    public Map<String, Long> getWritableDirectories() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Directory dir : this.crowdDirectoryService.findAllDirectories()) {
            if (!dir.getAllowedOperations().contains(OperationType.CREATE_USER) || !dir.getAllowedOperations().contains(OperationType.UPDATE_USER) || !dir.getAllowedOperations().contains(OperationType.UPDATE_GROUP)) continue;
            logger.debug("Found writable directory {} {}", (Object)dir.getId(), (Object)dir.getName());
            ret.put(dir.getName(), dir.getId());
        }
        return ret;
    }

    public void load() {
        logger.info("Loading Configuration");
        String xmlString = (String)this.pluginSettings.get("com.resolution.atlasplugins.samlsso:xmlConfiguration");
        if (xmlString == null) {
            logger.warn("no XML configuration stored, creating a new one");
            this.configurationData = new ConfigurationData();
            this.configurationDefaultSetter.addDefaults(this.configurationData);
            this.configurationData = this.configurationMigrator.migrate(this.pluginSettings, this.configurationData);
            this.store();
        } else {
            logger.debug("Loading configuration from {}", (Object)xmlString);
            this.configurationData = this.load(xmlString);
        }
    }

    public ConfigurationData load(String xmlString) {
        StringReader stringReader = new StringReader(xmlString);
        ConfigurationData config = (ConfigurationData)JAXB.unmarshal((Reader)stringReader, ConfigurationData.class);
        this.configurationDefaultSetter.addDefaults(config);
        return config;
    }

    public String getXml() {
        StringWriter stringWriter = new StringWriter();
        ConfigurationData simplifiedConfigurationData = this.configurationDefaultSetter.clearDefaults(this.configurationData);
        JAXB.marshal((Object)simplifiedConfigurationData, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        return xmlString;
    }

    public void store() {
        String xmlString = this.getXml();
        logger.debug("Storing configuration to {}", (Object)xmlString);
        this.pluginSettings.put("com.resolution.atlasplugins.samlsso:xmlConfiguration", (Object)xmlString);
    }

    public boolean update(ConfigurationData newConfig) {
        List<String> validationMessages = this.configurationValidator.validate(newConfig);
        if (validationMessages.isEmpty()) {
            this.configurationDefaultSetter.addDefaults(newConfig);
            this.renumberIdps(newConfig);
            this.configurationData = newConfig;
            this.store();
            this.fireConfigurationUpdated();
            return true;
        }
        logger.warn("New config is not valid ");
        for (String msg : validationMessages) {
            logger.error(msg);
        }
        return false;
    }

    public boolean isEnableIdPSelection() {
        return this.configurationData.enableIdPSelection;
    }

    public boolean isEnableIdPSelectionByEmailAddress() {
        return this.configurationData.enableIdPSelectionByEmailAddress;
    }

    public boolean isOverrideLoginUrl() {
        return this.configurationData.overrideLoginUrl;
    }

    public boolean isOverrideLogoutUrl() {
        return this.configurationData.overrideLogoutUrl;
    }

    public boolean isRedirectDashboardUrl() {
        return this.configurationData.redirectDashboardUrl;
    }

    public boolean isEnableUserForLogin() {
        return this.configurationData.enableUserForLogin;
    }

    public String getUserGroupForEnablement() {
        return this.configurationData.userGroupForEnablement;
    }

    public boolean isRedirectWithPOST() {
        return this.configurationData.redirectWithPOST;
    }

    public boolean isRedirectServiceDeskLogin() {
        return this.configurationData.redirectServiceDeskLogin;
    }

    public String getDefaultRedirectUrl() {
        return this.configurationData.defaultRedirectUrl;
    }

    public String getLogoutUrl() {
        if (this.configurationData.logoutUrl != null && !this.configurationData.logoutUrl.isEmpty()) {
            return this.configurationData.logoutUrl;
        }
        return null;
    }

    public boolean isCustomLogoutUrl() {
        return this.configurationData.logoutUrl != null && !this.configurationData.logoutUrl.isEmpty();
    }

    public void setEnforceResponseValidityDates(boolean enforceResponseValidityDates) {
        this.configurationData.enforceResponseValidityDates = enforceResponseValidityDates;
    }

    public boolean isEnforceResponseValidityDates() {
        return this.configurationData.enforceResponseValidityDates;
    }

    public int getClockSkew() {
        return this.configurationData.clockSkew;
    }

    public boolean isEnforceResponseIDUniqueness() {
        return this.configurationData.enforceResponseIDUniqueness;
    }

    public void setEnforceResponseIDUniqueness(boolean enforceResponseIDUniqueness) {
        this.configurationData.enforceResponseIDUniqueness = enforceResponseIDUniqueness;
    }

    public String getGroupsToAddUserTo() {
        return this.configurationData.groupsToAddUserTo;
    }

    public List<String> getGroupsToAddUserToList() {
        return Utils.splitString(this.getGroupsToAddUserTo());
    }

    public String getJiraIssueCollectors() {
        return this.configurationData.jiraIssueCollectors;
    }

    public List<String> getJiraIssueCollectorsList() {
        return Utils.splitString(this.getJiraIssueCollectors());
    }

    public String getNonSsoUserAgents() {
        return this.configurationData.nonSsoUserAgents;
    }

    public List<String> getNonSsoUserAgentsList() {
        return Utils.splitString(this.getNonSsoUserAgents());
    }

    public String getNonSsoDestinations() {
        return this.configurationData.nonSsoDestinations;
    }

    public List<String> getNonSsoDestinationsList() {
        return Utils.splitString(this.getNonSsoDestinations());
    }

    public String getEnforceSsoDestinations() {
        return this.configurationData.enforceSsoDestinations;
    }

    public List<String> getEnforceSsoDestinationsList() {
        return Utils.splitString(this.getEnforceSsoDestinations());
    }

    public String getLicenseString() {
        return this.configurationData.licenseString;
    }

    public String getErrorPageTemplate() {
        return this.configurationData.errorPageTemplate;
    }

    public String getServiceDeskErrorPageTemplate() {
        return this.configurationData.serviceDeskErrorPageTemplate;
    }

    public String getLoggedOutPageTemplate() {
        return this.configurationData.loggedOutPageTemplate;
    }

    public String getIdpSelectionPageTemplate() {
        return this.configurationData.idpSelectionPageTemplate;
    }

    public String getIdpByEmailPageTemplate() {
        return this.configurationData.idpByEmailPageTemplate;
    }

    public boolean isSetRememberMeCookie() {
        return this.configurationData.setRememberMeCookie;
    }

    public List<IdpConfiguration> getIdpConfigurations() {
        ArrayList<IdpConfiguration> ret = new ArrayList<IdpConfiguration>(this.configurationData.idpConfigurations.size());
        for (IdpConfiguration current : this.configurationData.idpConfigurations) {
            ret.add(current.clone());
        }
        return ret;
    }

    public Map<String, Integer> getEmailDomainIdMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (IdpConfiguration idpConfig : this.configurationData.idpConfigurations) {
            for (String emailDomain : idpConfig.getEmailDomainsList()) {
                ret.put(emailDomain, idpConfig.getId());
            }
        }
        return ret;
    }

    public String getLicenseMessage() {
        if (this.licenseChecker == null) {
            return null;
        }
        return this.licenseChecker.checkOwnLicense(this.getLicenseString()).getMessage();
    }

    public boolean isLicensed() {
        if (this.licenseChecker == null) {
            return false;
        }
        return this.licenseChecker.checkLicense().isLicensed();
    }

    public void addListener(PluginConfigurationListener listener) {
        if (!this.configurationListeners.contains(listener)) {
            this.configurationListeners.add(listener);
            logger.debug("Added ConfigurationListener");
        } else {
            logger.debug("ConfigurationListener is already registered, skipping.");
        }
        logger.debug("{} ConfigurationListeners are registered", (Object)this.configurationListeners.size());
    }

    public void removeListener(PluginConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    protected void fireConfigurationUpdated() {
        for (PluginConfigurationListener listener : this.configurationListeners) {
            listener.configurationUpdated();
        }
    }

    public ConfigurationData getConfigurationData() {
        logger.debug("Directories:");
        ConfigurationData ret = this.configurationData.clone();
        ret.directoryList = this.getWritableDirectories();
        ret.defaultIdpConfiguration = this.getDefaultIdpConfiguration();
        return ret;
    }

    public String getConfigurationDataAsXml() {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this.configurationData, (Writer)writer);
        return writer.toString();
    }

    public List<String> validate(ConfigurationData configTransfer) {
        return this.configurationValidator.validate(configTransfer);
    }

    public void addDefaults(ConfigurationData configurationData) {
        this.configurationDefaultSetter.addDefaults(configurationData);
    }

    public IdpConfiguration getDefaultIdpConfiguration() {
        IdpConfiguration ret = new IdpConfiguration();
        this.configurationDefaultSetter.addDefaults(ret);
        return ret;
    }

    public void renumberIdps(ConfigurationData configurationData) {
        int newIndex = 1;
        for (IdpConfiguration current : configurationData.idpConfigurations) {
            Integer currentId = current.getId();
            if (currentId == null || currentId != newIndex) {
                current.setId(newIndex);
                logger.info("Renumbering IdP, setting id from {} to {}", (Object)currentId, (Object)newIndex);
            } else {
                logger.debug("Keeping IdP id {}", (Object)currentId);
            }
            ++newIndex;
        }
    }
}

