/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
public final class ConfigurationData
implements Cloneable {
    @XmlTransient
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationData.class);
    public String defaultRedirectUrl;
    public boolean overrideLoginUrl;
    public boolean overrideLogoutUrl;
    public String logoutUrl;
    public boolean enableUserForLogin;
    public String userGroupForEnablement;
    public boolean redirectWithPOST = true;
    public boolean enableIdPSelection;
    public String jiraGroups;
    public String licenseString;
    public String useridTransformationRegex;
    public String useridTransformationReplacement;
    public String errorPageTemplate;
    public String loggedOutPageTemplate;
    public String idpSelectionPageTemplate;
    public String idpByEmailPageTemplate;
    public String serviceDeskErrorPageTemplate;
    public boolean enableIdPSelectionByEmailAddress;
    public String groupsToAddUserTo;
    public String nonSsoDestinations;
    public String nonSsoUserAgents;
    public String enforceSsoDestinations;
    public String jiraIssueCollectors;
    public boolean redirectServiceDeskLogin;
    public boolean redirectDashboardUrl;
    public boolean setRememberMeCookie = false;
    public boolean enforceResponseValidityDates = true;
    public boolean enforceResponseIDUniqueness = true;
    public int clockSkew = 60;
    public String licenseMessage;
    public boolean licensed;
    public Map<String, Long> directoryList;
    @XmlElementWrapper(name="idpConfigurations")
    @XmlElement(name="idpConfiguration")
    public List<IdpConfiguration> idpConfigurations = new ArrayList<IdpConfiguration>();
    public IdpConfiguration defaultIdpConfiguration;

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof ConfigurationData)) {
            return false;
        }
        ConfigurationData other = (ConfigurationData)otherObject;
        if (this.idpConfigurations.size() != other.idpConfigurations.size()) {
            return false;
        }
        for (int i = 0; i < this.idpConfigurations.size(); ++i) {
            if (this.idpConfigurations.get(i).equals(other.idpConfigurations.get(i))) continue;
            return false;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("idpConfigurations")) continue;
            try {
                Object thisField = fields[i].get(this);
                Object otherField = fields[i].get(other);
                if (thisField == null && otherField != null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField != null && otherField == null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField == null || otherField == null || thisField.equals(otherField)) continue;
                logger.debug("{} differs", (Object)fields[i].getName());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public ConfigurationData clone() {
        ConfigurationData ret = new ConfigurationData();
        for (IdpConfiguration idpconfig : this.idpConfigurations) {
            ret.idpConfigurations.add(idpconfig.clone());
        }
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("idpConfigurations") || Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                fields[i].set(ret, fields[i].get(this));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    protected static String newLinesToSeparators(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().replaceAll("\n", ",");
    }

    protected static String separatorsToNewLines(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(",", "\n");
    }
}

