/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.configuration.CertificateCheck;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.opensaml.xml.security.x509.X509Util;

@Path(value="/checkCertificate")
public class CertificateCheckingResource {
    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response checkCertificate(String base64Encoded) {
        Response response;
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        CertificateCheck check = new CertificateCheck(base64Encoded);
        if (!check.isCertSet()) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No certificate set").cacheControl(cacheControl).build();
        } else {
            try {
                Collection<X509Certificate> certs = X509Util.decodeCertificate(base64Encoded.getBytes());
                String message = certs.iterator().next().toString();
                response = Response.ok((Object)message).build();
            }
            catch (Exception e) {
                String message = "Decoding certificate failed: " + e.getMessage();
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).cacheControl(cacheControl).build();
            }
        }
        return response;
    }
}

