/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.cluster;

import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificationListener;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterNotificator
implements ClusterNotificator {
    private Collection<ClusterNotificationListener> notificationListeners = new ArrayList<ClusterNotificationListener>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractClusterNotificator.class);

    @Override
    public void register(ClusterNotificationListener clusterNotificationListener) {
        this.notificationListeners.add(clusterNotificationListener);
        logger.trace("Added listener, we now have {} listeners", (Object)this.notificationListeners.size());
    }

    @Override
    public void remove(ClusterNotificationListener clusterNotificationListener) {
        this.notificationListeners.remove(clusterNotificationListener);
    }

    protected void notifiyListeners(String message) {
        logger.trace("Sending message {} to {} listeners", (Object)message, (Object)this.notificationListeners.size());
        for (ClusterNotificationListener listener : this.notificationListeners) {
            listener.receiveClusterNotification(message);
        }
    }
}

